/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.ant.Logger;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.tools.ant.BuildException;

public class JbiSetRuntimeLoggersTask
extends JbiTargetTask {
    private static final String LOGGER_SUCCESS_STATUS_KEY = "jbi.ui.ant.set.logger.successful";
    private static final String LOGGER_FAILED_STATUS_KEY = "jbi.ui.ant.set.logger.failed";
    private static final String LOGGER_PARTIAL_SUCCESS_STATUS_KEY = "jbi.ui.ant.set.logger.partial.success";
    private List mLoggerList;

    private void debugPrintParams(Properties params) {
        if (params == null) {
            this.logDebug("Set Configuration params are NULL");
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        params.list(out);
        out.close();
        this.logDebug(stringWriter.getBuffer().toString());
    }

    private String createFormatedSuccessJbiResultMessage(String i18nKey, Object[] args) {
        String msgCode = this.getI18NBundle().getMessage(i18nKey + ".ID");
        String msg = this.getI18NBundle().getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml("JBI_ANT_TASK_SET_CONFIG", true, "INFO", msgCode, msg, args, null);
        JBIManagementMessage mgmtMsg = null;
        mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)jbiResultXml);
        return mgmtMsg != null ? mgmtMsg.getMessage() : msg;
    }

    private void executeSetRuntimeLoggers() throws BuildException {
        this.logDebug("Executing Set Runtime Loggers ....");
        String target = this.getValidTarget();
        boolean restartRequired = false;
        try {
            List loggerList = this.getLoggerList();
            boolean emptyFlag = true;
            for (Logger logger : loggerList) {
                String theName = "" + logger.getName();
                if (theName.compareTo("") == 0) continue;
                if (("" + logger.getLevel()).toUpperCase().compareTo("DEFAULT") != 0) {
                    this.logDebug("logger name: " + logger.getName() + " logger level: " + Level.parse(logger.getLevel()) + " target: " + target);
                    this.getJBIAdminCommands().setRuntimeLoggerLevel(logger.getName(), Level.parse(logger.getLevel()), target, target);
                } else {
                    this.getJBIAdminCommands().setRuntimeLoggerLevel(logger.getName(), null, target, target);
                }
                emptyFlag = false;
            }
            if (emptyFlag) {
                String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.no.input.runtime.logger.data.found", null);
                throw new BuildException(msg, this.getLocation());
            }
            String i18nKey = "jbi.ui.ant.task.info.logger.done.on.target";
            Object[] args = new Object[]{target};
            this.printTaskSuccess(this.createFormatedSuccessJbiResultMessage(i18nKey, args));
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing Set Configuration Task....");
        this.executeSetRuntimeLoggers();
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return LOGGER_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return LOGGER_SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getTaskPartialSuccessStatusI18NKey() {
        return LOGGER_PARTIAL_SUCCESS_STATUS_KEY;
    }

    protected List getLoggerList() {
        if (this.mLoggerList == null) {
            this.mLoggerList = new ArrayList();
        }
        return this.mLoggerList;
    }

    public Logger createLogger() {
        Logger logger = new Logger();
        this.getLoggerList().add(logger);
        return logger;
    }
}

