/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiQueryTask;
import com.sun.jbi.ui.common.JBIComponentInfo;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;

public class JbiListSharedLibrariesTask
extends JbiQueryTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.list.shared.lib.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.list.shared.lib.failed";
    private String mSharedLibraryName;
    private String mComponentName;
    private boolean mDescriptor;

    public String getSharedLibraryName() {
        return this.mSharedLibraryName;
    }

    public void setSharedLibraryName(String sharedLibraryName) {
        this.mSharedLibraryName = sharedLibraryName;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public boolean getDescriptor() {
        return this.mDescriptor;
    }

    public void setDescriptor(boolean descriptor) {
        this.mDescriptor = descriptor;
    }

    @Override
    public void executeTask() throws BuildException {
        this.initXmlOutput(JBIComponentInfo.writeAsXmlText(new ArrayList()));
        String descriptor = null;
        String target = this.getValidTarget();
        try {
            String result;
            String name = this.getSharedLibraryName();
            String compName = this.getComponentName();
            if (null != name && name.length() > 0) {
                result = this.getJBIAdminCommands().showSharedLibrary(name, compName, target);
                this.setSingleQueryResultType();
                if (this.mDescriptor && (descriptor = this.getJBIAdminCommands().getSharedLibraryInstallationDescriptor(name)) == null) {
                    String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.show.shared.library.descriptor.not.found", new String[]{name});
                    throw new Exception(errMsg);
                }
            } else {
                if (this.mDescriptor) {
                    String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.show.shared.library.descriptor.single.only", null);
                    throw new Exception(errMsg);
                }
                result = this.getJBIAdminCommands().listSharedLibraries(compName, target);
            }
            this.printComponentQueryResults(result);
            if (descriptor != null) {
                this.printMessage("");
                this.printMessage(this.getI18NBundle().getMessage("jbi.ui.ant.print.shared.lib.descriptor"));
                this.printMessage(descriptor);
                this.printMessage("");
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getEmptyQueryResultI18NKey() {
        return "jbi.ui.ant.print.no.slib";
    }

    @Override
    protected String getQueryResultHeaderI18NKey() {
        return "jbi.ui.ant.print.slib.header";
    }

    @Override
    protected String getQueryResultHeaderSeparatorI18NKey() {
        return "jbi.ui.ant.print.comp.info.header.separator";
    }

    @Override
    protected String getQueryResultPageSeparatorI18NKey() {
        return "jbi.ui.ant.print.comp.info.separator";
    }

    @Override
    protected String getEmptyQueryResultI18NMessage() {
        if (this.getQueryResultType() == 2) {
            return this.getI18NBundle().getMessage("jbi.ui.ant.print.no.slib.with.name", (Object)this.getSharedLibraryName());
        }
        return this.getI18NBundle().getMessage(this.getEmptyQueryResultI18NKey());
    }
}

