/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.ant.Param;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;

public class JbiListRuntimeConfigurationTask
extends JbiTargetTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.list.configuration.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.list.configuration.failed";
    private static final String INSTANCE_ERROR_PROP = "com.sun.jbi.cluster.instance.error";
    private List mParamList;

    private void executeListRuntimeConfiguration() throws BuildException {
        this.logDebug("Executing List Runtime Configuration ....");
        try {
            String target = this.getValidTarget();
            List tmpParamList = this.getParamList();
            ArrayList paramList = new ArrayList(tmpParamList);
            for (Param param : tmpParamList) {
                String paramName;
                if (param == null || (paramName = param.getName()) == null || paramName.trim().compareTo("") != 0) continue;
                paramList.remove(param);
            }
            Properties returnProps = this.getJBIAdminCommands().getRuntimeConfiguration(target);
            this.printRuntimeConfiguration(paramList, returnProps);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing List Configuration Task....");
        this.executeListRuntimeConfiguration();
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    protected String getEmptyQueryResultI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.empty" : "jbi.ui.ant.print.jbi.comp.config.info.empty";
    }

    protected String getQueryResultHeaderI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header" : "jbi.ui.ant.print.jbi.comp.config.info.header";
    }

    protected String getQueryResultHeaderSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header.separator" : "jbi.ui.ant.print.jbi.comp.config.info.header.separator";
    }

    protected String getQueryResultPageSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.separator" : "jbi.ui.ant.print.jbi.comp.config.info.separator";
    }

    protected void printRuntimeConfiguration(List paramList, Properties returnProps) {
        this.logDebug("Printing Rimtime Configuration ....");
        boolean isRuntime = true;
        String header = this.getI18NBundle().getMessage(this.getQueryResultHeaderI18NKey(isRuntime), (Object)this.getValidTarget());
        String headerSeparator = this.getI18NBundle().getMessage(this.getQueryResultHeaderSeparatorI18NKey(isRuntime));
        String pageSeparator = this.getI18NBundle().getMessage(this.getQueryResultPageSeparatorI18NKey(isRuntime));
        String emptyResult = this.getI18NBundle().getMessage(this.getEmptyQueryResultI18NKey(isRuntime));
        StringWriter stringWriter = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(stringWriter);
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (returnProps == null || returnProps.size() <= 0) {
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
        } else if (paramList == null || paramList.size() <= 0) {
            TreeSet<Object> keys = new TreeSet<Object>(returnProps.keySet());
            for (Object e : keys) {
                String name = (String)e;
                String value = returnProps.getProperty(name, "");
                String param = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.config.param", (Object)name, (Object)value);
                msgWriter.println(param);
            }
            msgWriter.println(pageSeparator);
        } else {
            Iterator itr = paramList.iterator();
            while (itr.hasNext()) {
                String msg;
                String name = "" + ((Param)itr.next()).getName();
                String string = returnProps.getProperty(name);
                if (string != null) {
                    msg = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.config.param", (Object)name, (Object)string);
                    msgWriter.println(msg);
                    continue;
                }
                msg = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.config.param.not.retrieved", (Object)name);
                msgWriter.println(msg);
            }
            msgWriter.println(pageSeparator);
        }
        msgWriter.close();
        this.printMessage(stringWriter.getBuffer().toString());
    }

    protected List getParamList() {
        if (this.mParamList == null) {
            this.mParamList = new ArrayList();
        }
        return this.mParamList;
    }

    public Param createParam() {
        Param param = new Param();
        this.getParamList().add(param);
        return param;
    }
}

