/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.AppVariable;
import com.sun.jbi.ui.ant.JbiTargetTask;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public class JbiListApplicationVariablesTask
extends JbiTargetTask {
    private static final String APPVARIABLE_SUCCESS_STATUS_KEY = "jbi.ui.ant.list.appvariable.successful";
    private static final String APPVARIABLE_FAILED_STATUS_KEY = "jbi.ui.ant.list.appvariable.failed";
    private static final String INSTANCE_ERROR_PROP = "com.sun.jbi.cluster.instance.error";
    private static final String APP_CONFIG_NAME_KEY = "configurationName";
    private String mComponentName = null;
    private List mAppVariableList;
    private boolean mShowFullLength = false;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public boolean getShowFullLength() {
        return this.mShowFullLength;
    }

    public void setShowFullLength(boolean showFullLength) {
        this.mShowFullLength = showFullLength;
    }

    private void executeListApplicationVariables(String componentName) throws BuildException {
        try {
            String target = this.getValidTarget();
            boolean showFullLength = this.getShowFullLength();
            List appVariableList = this.getAppVariableList();
            if (componentName == null || componentName.compareTo("") == 0) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.nullCompName", null);
                throw new BuildException(errMsg);
            }
            this.logDebug("Executing List component application variables ....");
            Properties resultProp = this.getJBIAdminCommands().getApplicationVariables(componentName, target);
            ArrayList printList = new ArrayList(appVariableList);
            for (AppVariable appVariable : appVariableList) {
                String appVariableName;
                if (appVariable == null || (appVariableName = "" + appVariable.getName()).trim().compareTo("") != 0) continue;
                printList.remove(appVariable);
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter msgWriter = new PrintWriter(stringWriter);
            String showFullLengthStr = showFullLength ? "true" : "false";
            this.printApplicationVariables(componentName, printList, resultProp, target, msgWriter, showFullLength);
            msgWriter.close();
            this.printMessage(stringWriter.getBuffer().toString());
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing List Configuration Task....");
        String compName = this.getComponentName();
        this.executeListApplicationVariables(compName);
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return APPVARIABLE_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return APPVARIABLE_SUCCESS_STATUS_KEY;
    }

    protected String getEmptyQueryResultI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.empty" : "jbi.ui.ant.print.jbi.comp.config.info.empty";
    }

    protected String getQueryResultHeaderI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header" : "jbi.ui.ant.print.jbi.comp.config.info.header";
    }

    protected String getQueryResultHeaderSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header.separator" : "jbi.ui.ant.print.jbi.comp.config.info.header.separator";
    }

    protected String getQueryResultPageSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.separator" : "jbi.ui.ant.print.jbi.comp.config.info.separator";
    }

    protected void printApplicationVariables(String compName, List appVariableList, Properties returnProp, String target, PrintWriter msgWriter, boolean showFullLength) {
        String SPACE = "  ";
        String header = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.appvariable.info.header", (Object[])new String[]{compName, target});
        String infoNames = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.appvariable.info.column.names");
        String headerSeparatorChar = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.appvariable.info.header.separator.char");
        String pageSeparatorChar = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.appvariable.info.separator.char");
        String emptyResult = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.appvariable.info.empty");
        int maxNameLength = 20;
        int maxTypeLength = 10;
        int maxValueLength = 46;
        int totalLen = maxNameLength + SPACE.length() + maxTypeLength + SPACE.length() + maxValueLength;
        StringTokenizer nameTk = new StringTokenizer(infoNames, ",");
        String nameStr = nameTk.nextToken();
        String typeStr = nameTk.nextToken();
        String valueStr = nameTk.nextToken();
        String headerSeparator = "";
        String pageSeparator = "";
        for (int i = 0; i < totalLen; ++i) {
            headerSeparator = headerSeparator + headerSeparatorChar;
            pageSeparator = pageSeparator + pageSeparatorChar;
        }
        String formatStr = "%1$-" + maxNameLength + "s  %2$-" + maxTypeLength + "s  %3$-" + maxValueLength + "s\n";
        if (returnProp == null || returnProp.size() <= 0) {
            msgWriter.println(headerSeparator);
            msgWriter.println(header);
            msgWriter.println(headerSeparator);
            msgWriter.format(formatStr, nameStr, typeStr, valueStr);
            msgWriter.println(pageSeparator);
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
        } else {
            Vector<AppVariable> entries = new Vector<AppVariable>();
            TreeSet<Object> keys = null;
            keys = appVariableList == null || appVariableList.size() <= 0 ? new TreeSet<Object>(returnProp.keySet()) : new TreeSet(appVariableList);
            for (Object e : keys) {
                String name = null;
                name = e != null && e instanceof AppVariable ? "" + ((AppVariable)e).getName() : "" + (String)e;
                String tmpStr = returnProp.getProperty(name);
                String valueType = null;
                String value = null;
                if (tmpStr == null) continue;
                if (tmpStr.length() > 0 && tmpStr.charAt(0) == '[') {
                    int closingBrkt = tmpStr.indexOf(93);
                    if (closingBrkt == -1) {
                        String errMsg = this.getI18NBundle().getMessage("jbi.ui.ant.list.appvariable.wrong.format");
                        throw new BuildException(errMsg);
                    }
                    valueType = tmpStr.substring(1, closingBrkt);
                    value = tmpStr.substring(closingBrkt + 1);
                } else {
                    valueType = "STRING";
                    value = tmpStr;
                }
                if (showFullLength) {
                    maxNameLength = maxNameLength < (e + "").length() ? (name + "").length() : maxNameLength;
                    maxTypeLength = maxTypeLength < (valueType + "").length() ? (valueType + "").length() : maxTypeLength;
                    maxValueLength = maxValueLength < (value + "").length() ? (value + "").length() : maxValueLength;
                }
                AppVariable entry = new AppVariable(name, valueType, value);
                entries.add(entry);
            }
            if (showFullLength) {
                totalLen = maxNameLength + SPACE.length() + maxTypeLength + SPACE.length() + maxValueLength;
                headerSeparator = "";
                pageSeparator = "";
                for (int i = 0; i < totalLen; ++i) {
                    headerSeparator = headerSeparator + headerSeparatorChar;
                    pageSeparator = pageSeparator + pageSeparatorChar;
                }
            }
            formatStr = "%1$-" + maxNameLength + "s  %2$-" + maxTypeLength + "s  %3$-" + maxValueLength + "s\n";
            msgWriter.println(headerSeparator);
            msgWriter.println(header);
            msgWriter.println(headerSeparator);
            msgWriter.format(formatStr, nameStr, typeStr, valueStr);
            msgWriter.println(pageSeparator);
            Enumeration enu = entries.elements();
            while (enu.hasMoreElements()) {
                AppVariable appVariable = (AppVariable)enu.nextElement();
                String printNameStr = appVariable.getName();
                String printTypeStr = appVariable.getType();
                String printValueStr = appVariable.getValue();
                if (!showFullLength) {
                    printNameStr = (printNameStr + "").length() > maxNameLength ? (printNameStr + "").substring(0, maxNameLength - 3) + "..." : printNameStr;
                    printTypeStr = (printTypeStr + "").length() > maxTypeLength ? (printTypeStr + "").substring(0, maxTypeLength - 3) + "..." : printTypeStr;
                    printValueStr = (printValueStr + "").length() > maxValueLength ? (printValueStr + "").substring(0, maxValueLength - 3) + "..." : printValueStr;
                }
                msgWriter.format(formatStr, printNameStr, printTypeStr, printValueStr);
            }
            msgWriter.println(pageSeparator);
        }
    }

    protected List getAppVariableList() {
        if (this.mAppVariableList == null) {
            this.mAppVariableList = new ArrayList();
        }
        return this.mAppVariableList;
    }

    public AppVariable createAppVariable() {
        AppVariable appVariable = new AppVariable();
        this.getAppVariableList().add(appVariable);
        return appVariable;
    }
}

