/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.ant.Param;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;

public class JbiListApplicationConfigurationsTask
extends JbiTargetTask {
    private static final String APPCONFIG_SUCCESS_STATUS_KEY = "jbi.ui.ant.list.appconfig.successful";
    private static final String APPCONFIG_FAILED_STATUS_KEY = "jbi.ui.ant.list.appconfig.failed";
    private static final String INSTANCE_ERROR_PROP = "com.sun.jbi.cluster.instance.error";
    private static final String APP_CONFIG_NAME_KEY = "configurationName";
    private String mComponentName = null;
    private List mAppConfigList;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    private void executeListApplicationConfigurations(String componentName) throws BuildException {
        try {
            String target = this.getValidTarget();
            List tmpAppConfigList = this.getAppConfigList();
            ArrayList appConfigList = new ArrayList(tmpAppConfigList);
            for (Param appConfig : tmpAppConfigList) {
                String appConfigName;
                if (appConfig == null || (appConfigName = appConfig.getName()) == null || appConfigName.trim().compareTo("") != 0) continue;
                appConfigList.remove(appConfig);
            }
            if (componentName == null || componentName.compareTo("") == 0) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.nullCompName", null);
                throw new BuildException(errMsg);
            }
            this.logDebug("Executing List component application configurations ....");
            if (appConfigList.size() == 0) {
                this.logDebug("Executing List all component application configurations ....");
                Map resultMap = this.getJBIAdminCommands().getApplicationConfigurations(componentName, target);
                if (resultMap == null) {
                    String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.no.appconfig.data.retrieved", new String[]{componentName});
                    throw new BuildException(errMsg);
                }
                this.printApplicationConfigurations(componentName, resultMap, target);
            } else {
                Iterator it = appConfigList.iterator();
                TreeMap<String, Properties> resultMap = new TreeMap<String, Properties>();
                while (it.hasNext()) {
                    Param param = (Param)it.next();
                    String appConfigName = param.getName();
                    if (appConfigName == null || appConfigName.compareTo("") == 0) continue;
                    this.logDebug("Executing List component application configuration named " + appConfigName + " for component " + componentName);
                    Properties resultProp = this.getJBIAdminCommands().getApplicationConfiguration(componentName, target, appConfigName);
                    if (resultProp == null) {
                        String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.appconfig.not.exist", new String[]{appConfigName});
                        throw new BuildException(errMsg);
                    }
                    resultMap.put(appConfigName, resultProp);
                }
                this.printApplicationConfigurations(componentName, resultMap, target);
            }
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing List Configuration Task....");
        String compName = this.getComponentName();
        this.executeListApplicationConfigurations(compName);
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return APPCONFIG_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return APPCONFIG_SUCCESS_STATUS_KEY;
    }

    protected String getEmptyQueryResultI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.empty" : "jbi.ui.ant.print.jbi.comp.config.info.empty";
    }

    protected String getQueryResultHeaderI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header" : "jbi.ui.ant.print.jbi.comp.config.info.header";
    }

    protected String getQueryResultHeaderSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header.separator" : "jbi.ui.ant.print.jbi.comp.config.info.header.separator";
    }

    protected String getQueryResultPageSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.separator" : "jbi.ui.ant.print.jbi.comp.config.info.separator";
    }

    protected void printApplicationConfigurations(String compName, Map<String, Properties> appConfigList, String target) {
        this.logDebug("Printing Application Configuration .... for component=" + compName + " on target=" + target);
        String header = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.appconfig.info.header", (Object[])new String[]{compName, target});
        String headerSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.appconfig.info.header.separator");
        String pageSeparator = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.appconfig.info.separator");
        String emptyResult = this.getI18NBundle().getMessage("jbi.ui.ant.list.no.appconfig.data.retrieved", (Object[])new String[]{compName});
        StringWriter stringWriter = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(stringWriter);
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (appConfigList.size() == 0) {
            msgWriter.println(emptyResult);
        } else {
            for (String appConfigName : appConfigList.keySet()) {
                Properties appConfigParamList = appConfigList.get(appConfigName);
                String appConfigHeader = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.appconfig.info.name", (Object)appConfigName, (Object)target);
                msgWriter.println(appConfigHeader);
                this.printApplicationConfigurationRecursively(appConfigParamList, msgWriter, "", -1);
            }
        }
        msgWriter.close();
        this.printMessage(stringWriter.getBuffer().toString());
    }

    protected void printApplicationConfigurationRecursively(Properties appConfigParamList, PrintWriter msgWriter, String theTab, int passInArrayIndex) {
        String localTab = "\t" + theTab;
        TreeSet<Object> keys = new TreeSet<Object>(appConfigParamList.keySet());
        String arrayKey = null;
        boolean inArray = false;
        for (Object e : keys) {
            String name = (String)e;
            String valueString = appConfigParamList.getProperty(name);
            int dotIndex = -1;
            if (name != null && name.indexOf(46) > 0) {
                dotIndex = name.indexOf(46);
                String tmpArrayKey = null;
                int theIndex = -1;
                tmpArrayKey = name.substring(0, dotIndex);
                String arrayIndex = name.substring(dotIndex + 1);
                try {
                    theIndex = Integer.parseInt(arrayIndex);
                    if (tmpArrayKey != null && tmpArrayKey.compareTo(arrayKey + "") != 0) {
                        msgWriter.println(localTab + tmpArrayKey + ":");
                    }
                    if (valueString.indexOf(",") <= 0) {
                        msgWriter.println(localTab + "\t[" + arrayIndex + "] " + valueString);
                    } else {
                        this.printApplicationConfigurationRecursively(this.stringToProperties(valueString), msgWriter, localTab, theIndex);
                    }
                    arrayKey = tmpArrayKey;
                }
                catch (NumberFormatException exp) {
                    if (valueString.indexOf(",") <= 0) {
                        msgWriter.println(localTab + name + "=" + valueString);
                        continue;
                    }
                    this.printApplicationConfigurationRecursively(this.stringToProperties(valueString), msgWriter, localTab, -1);
                }
                continue;
            }
            if (valueString.indexOf(",") > 0) {
                msgWriter.println(localTab + name + ":");
                this.printApplicationConfigurationRecursively(this.stringToProperties(valueString), msgWriter, localTab, -1);
                continue;
            }
            if (passInArrayIndex >= 0) {
                msgWriter.println(localTab + "[" + passInArrayIndex + "] " + name + "=" + valueString);
                passInArrayIndex = -1;
                inArray = true;
                continue;
            }
            if (inArray) {
                msgWriter.println(localTab + "    " + name + "=" + valueString);
                continue;
            }
            msgWriter.println(localTab + name + "=" + valueString);
        }
    }

    private Properties stringToProperties(String theStr) {
        Properties prop = new Properties();
        StringTokenizer commaTk = new StringTokenizer(theStr, ",");
        while (commaTk.hasMoreTokens()) {
            String value;
            String entryStr = commaTk.nextToken();
            StringTokenizer equalSignTk = new StringTokenizer(entryStr, "=");
            String key = equalSignTk.hasMoreTokens() ? equalSignTk.nextToken() : null;
            String string = value = equalSignTk.hasMoreTokens() ? equalSignTk.nextToken() : null;
            if (key == null) continue;
            prop.put(key, value + "");
        }
        return prop;
    }

    protected List getAppConfigList() {
        if (this.mAppConfigList == null) {
            this.mAppConfigList = new ArrayList();
        }
        return this.mAppConfigList;
    }

    public Param createAppConfig() {
        Param param = new Param();
        this.getAppConfigList().add(param);
        return param;
    }
}

