/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.AppVariable;
import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;

public class JbiCreateApplicationVariablesTask
extends JbiTargetTask {
    private static final String APPVARIABLE_SUCCESS_STATUS_KEY = "jbi.ui.ant.add.appvariable.successful";
    private static final String APPVARIABLE_FAILED_STATUS_KEY = "jbi.ui.ant.add.appvariable.failed";
    private static final String APPVARIABLE_PARTIAL_SUCCESS_STATUS_KEY = "jbi.ui.ant.add.appvariable.partial.success";
    private List mAppVariableList;
    private String mAppVariablesFile = null;
    private String mComponentName = null;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public String getAppVariables() {
        return this.mAppVariablesFile;
    }

    public void setAppVariables(String appVariablesFile) {
        this.mAppVariablesFile = appVariablesFile;
    }

    private void debugPrintParams(Properties params) {
        if (params == null) {
            this.logDebug("Set Configuration params are NULL");
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        params.list(out);
        out.close();
        this.logDebug(stringWriter.getBuffer().toString());
    }

    private String createFormatedSuccessJbiResultMessage(String i18nKey, Object[] args) {
        String msgCode = this.getI18NBundle().getMessage(i18nKey + ".ID");
        String msg = this.getI18NBundle().getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml("JBI_ANT_TASK_SET_CONFIG", true, "INFO", msgCode, msg, args, null);
        JBIManagementMessage mgmtMsg = null;
        mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)jbiResultXml);
        return mgmtMsg != null ? mgmtMsg.getMessage() : msg;
    }

    private void executeCreateApplicationVariables(List appVariableList, String compName, String target) throws Exception {
        this.logDebug("Set application variables, component name: " + compName + " target: " + target);
        Properties varsProps = new Properties();
        for (AppVariable appVar : appVariableList) {
            String appName = ("" + appVar.getName()).trim();
            if (appName.compareTo("") == 0) continue;
            String valueString = null;
            if (appVar.getType() != null && appVar.getType().compareTo("") != 0) {
                valueString = "[" + appVar.getType() + "]" + appVar.getValue();
                varsProps.setProperty(appVar.getName(), valueString);
                continue;
            }
            valueString = "[STRING]" + appVar.getValue();
            varsProps.setProperty(appVar.getName(), valueString);
        }
        String appVariablesFile = this.getAppVariables();
        if (appVariablesFile != null && appVariablesFile.compareTo("") != 0) {
            this.logDebug("the params file is " + appVariablesFile);
            Properties theProp = this.loadParamsFromFile(new File(appVariablesFile));
            TreeSet<Object> keys = new TreeSet<Object>(theProp.keySet());
            for (Object e : keys) {
                String name = (String)e;
                String value = theProp.getProperty(name, "");
                if ((value + "").indexOf("[") < (value + "").indexOf("]")) continue;
                value = "[STRING]" + value;
                theProp.setProperty(name, value);
            }
            varsProps.putAll((Map<?, ?>)theProp);
        }
        if (varsProps.size() == 0) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.list.no.input.appvariable.data.found", null);
            throw new BuildException(msg, this.getLocation());
        }
        this.debugPrintParams(varsProps);
        this.logDebug("Before calling common client addApplicationVariables method, component name: " + compName + " target: " + target + " varsProps: " + varsProps);
        String rtnXml = this.getJBIAdminCommands().addApplicationVariables(compName, target, varsProps);
        JBIManagementMessage mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)rtnXml);
        if (mgmtMsg.isFailedMsg()) {
            throw new Exception(rtnXml);
        }
        this.printTaskSuccess(mgmtMsg);
    }

    @Override
    public void executeTask() throws BuildException {
        try {
            String compName = this.getComponentName();
            String target = this.getValidTarget();
            List appVariableList = this.getAppVariableList();
            if (compName == null || compName.compareTo("") == 0) {
                String errMsg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.nullCompName", null);
                throw new BuildException(errMsg);
            }
            this.logDebug("Executing create application variables Task....");
            this.executeCreateApplicationVariables(appVariableList, compName, target);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return APPVARIABLE_FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return APPVARIABLE_SUCCESS_STATUS_KEY;
    }

    @Override
    protected String getTaskPartialSuccessStatusI18NKey() {
        return APPVARIABLE_PARTIAL_SUCCESS_STATUS_KEY;
    }

    protected List getAppVariableList() {
        if (this.mAppVariableList == null) {
            this.mAppVariableList = new ArrayList();
        }
        return this.mAppVariableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadParamsFromFile(File file) throws BuildException {
        String absFilePath = null;
        String fileName = null;
        if (file != null) {
            absFilePath = file.getAbsolutePath();
            fileName = file.getName();
        }
        if (file == null || !file.exists()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.not.exist", new Object[]{fileName});
            throw new BuildException(msg, this.getLocation());
        }
        if (file.isDirectory()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.is.directory", null);
            throw new BuildException(msg, this.getLocation());
        }
        Properties props = new Properties();
        this.logDebug("Loading " + file.getAbsolutePath());
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                props.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            return props;
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
    }

    public AppVariable createAppVariable() {
        AppVariable appVar = new AppVariable();
        this.getAppVariableList().add(appVar);
        return appVar;
    }
}

