/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.Util;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NBundle {
    private String mBundlePackageName = null;
    private ResourceBundle mBundle = null;

    public I18NBundle(String packageName) {
        this.mBundlePackageName = packageName;
        this.mBundle = null;
    }

    private void loadBundle(String packageName, String bundleName) {
        String bundleBaseName = packageName + "." + bundleName;
        ResourceBundle resBundle = null;
        try {
            resBundle = ResourceBundle.getBundle(bundleBaseName);
        }
        catch (MissingResourceException ex) {
            try {
                resBundle = ResourceBundle.getBundle(bundleBaseName, new Locale(""));
            }
            catch (Exception anyEx) {
                Util.logDebug(anyEx);
            }
        }
        if (resBundle != null) {
            this.mBundle = resBundle;
        }
    }

    public ResourceBundle getBundle() {
        if (this.mBundle == null) {
            this.loadBundle(this.mBundlePackageName, "Bundle");
            if (this.mBundle == null) {
                this.loadBundle(this.mBundlePackageName, "bundle");
            }
        }
        return this.mBundle;
    }

    public static String getFormattedMessage(String aI18NMsg, Object[] aArgs) {
        String formattedI18NMsg = aI18NMsg;
        try {
            MessageFormat mf = new MessageFormat(aI18NMsg);
            formattedI18NMsg = mf.format(aArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formattedI18NMsg;
    }

    public String getMessage(String aI18NKey, Object[] anArgsArray) {
        String i18nMessage = this.getBundle().getString(aI18NKey);
        if (anArgsArray != null) {
            return I18NBundle.getFormattedMessage(i18nMessage, anArgsArray);
        }
        return i18nMessage;
    }

    public String getMessage(String aI18NKey) {
        return this.getMessage(aI18NKey, null);
    }

    public String getMessage(String aI18NKey, Object arg1) {
        Object[] args = new Object[]{arg1};
        return this.getMessage(aI18NKey, args);
    }

    public String getMessage(String aI18NKey, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getMessage(aI18NKey, args);
    }

    public String getMessage(String aI18NKey, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getMessage(aI18NKey, args);
    }

    public static void main(String[] args) {
        Locale l = new Locale("");
        System.out.println("Locale : " + l);
        System.out.println("Default Locale : " + Locale.getDefault());
        I18NBundle bundle = new I18NBundle("com.sun.jbi.ui.ant");
        System.out.println(bundle.getMessage("jbi.ui.ant.jmx.msg.jmxmp.connected", new String[]{"xyz"}));
    }
}

