/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseReason;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.Reader;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.StandaloneProcessorSelector;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.glassfish.grizzly.asyncqueue.AsyncQueueIO;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.monitoring.MonitoringUtils;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorIO;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOAsyncQueueReader;
import org.glassfish.grizzly.nio.transport.TCPNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.transport.TCPNIOBindingHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTemporarySelectorReader;
import org.glassfish.grizzly.nio.transport.TCPNIOTemporarySelectorWriter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOUtils;

public final class TCPNIOTransport
extends NIOTransport
implements AsyncQueueEnabledTransport,
FilterChainEnabledTransport,
TemporarySelectorsEnabledTransport {
    static final Logger LOGGER = Grizzly.logger(TCPNIOTransport.class);
    public static final int MAX_RECEIVE_BUFFER_SIZE = Integer.getInteger(TCPNIOTransport.class.getName() + ".max-receive-buffer-size", Integer.MAX_VALUE);
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final boolean DEFAULT_KEEP_ALIVE = true;
    public static final int DEFAULT_LINGER = -1;
    public static final int DEFAULT_SERVER_CONNECTION_BACKLOG = 4096;
    private static final String DEFAULT_TRANSPORT_NAME = "TCPNIOTransport";
    final Collection<TCPNIOServerConnection> serverConnections;
    final AsyncQueueIO<SocketAddress> asyncQueueIO;
    int linger = -1;
    int serverConnectionBackLog = 4096;
    boolean tcpNoDelay = true;
    boolean isKeepAlive = true;
    private final Filter defaultTransportFilter;
    final RegisterChannelCompletionHandler selectorRegistrationHandler;
    private final TCPNIOConnectorHandler connectorHandler = new TransportConnectorHandler();
    private final TCPNIOBindingHandler bindingHandler = new TCPNIOBindingHandler(this);

    public TCPNIOTransport() {
        this(DEFAULT_TRANSPORT_NAME);
    }

    TCPNIOTransport(String name) {
        super(name);
        this.readBufferSize = -1;
        this.writeBufferSize = -1;
        this.selectorRegistrationHandler = new RegisterChannelCompletionHandler();
        this.asyncQueueIO = AsyncQueueIO.Factory.createImmutable(new TCPNIOAsyncQueueReader(this), new TCPNIOAsyncQueueWriter(this));
        this.attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
        this.defaultTransportFilter = new TCPNIOTransportFilter(this);
        this.serverConnections = new ConcurrentLinkedQueue<TCPNIOServerConnection>();
    }

    @Override
    protected TemporarySelectorIO createTemporarySelectorIO() {
        return new TemporarySelectorIO(new TCPNIOTemporarySelectorReader(this), new TCPNIOTemporarySelectorWriter(this));
    }

    @Override
    protected void listen() {
        for (TCPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                this.listenServerConnection(serverConnection);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TRANSPORT_START_SERVER_CONNECTION_EXCEPTION(serverConnection), e);
            }
        }
    }

    @Override
    protected int getDefaultSelectorRunnersCount() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

    void listenServerConnection(TCPNIOServerConnection serverConnection) throws IOException {
        serverConnection.listen();
    }

    @Override
    public TCPNIOServerConnection bind(int port) throws IOException {
        return this.bind(new InetSocketAddress(port));
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port) throws IOException {
        return this.bind(host, port, this.serverConnectionBackLog);
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port, int backlog) throws IOException {
        return this.bind(new InetSocketAddress(host, port), backlog);
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, this.serverConnectionBackLog);
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        return this.bindingHandler.bind(socketAddress, backlog);
    }

    @Override
    public TCPNIOServerConnection bindToInherited() throws IOException {
        return this.bindingHandler.bindToInherited();
    }

    @Override
    public TCPNIOServerConnection bind(String host, PortRange portRange, int backlog) throws IOException {
        return (TCPNIOServerConnection)this.bindingHandler.bind(host, portRange, backlog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Connection connection) {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (connection != null && this.serverConnections.remove(connection)) {
                GrizzlyFuture<Closeable> future = connection.close();
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                    future.recycle(false);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TRANSPORT_UNBINDING_CONNECTION_EXCEPTION(connection), e);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            for (Connection connection : this.serverConnections) {
                try {
                    this.unbind(connection);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Exception occurred when closing server connection: " + connection, e);
                }
            }
            this.serverConnections.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public GrizzlyFuture<Connection> connect(String host, int port) {
        return this.connectorHandler.connect(host, port);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress) {
        return this.connectorHandler.connect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, completionHandler);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connectorHandler.connect(remoteAddress, localAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, localAddress, completionHandler);
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        SelectableChannel nioChannel = ((NIOConnection)connection).getChannel();
        if (nioChannel != null) {
            try {
                nioChannel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
        }
        if (this.asyncQueueIO != null) {
            AsyncQueueWriter<SocketAddress> writer;
            AsyncQueueReader<SocketAddress> reader = this.asyncQueueIO.getReader();
            if (reader != null) {
                reader.onClose(connection);
            }
            if ((writer = this.asyncQueueIO.getWriter()) != null) {
                writer.onClose(connection);
            }
        }
    }

    TCPNIOConnection obtainNIOConnection(SocketChannel channel) {
        TCPNIOConnection connection = new TCPNIOConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    TCPNIOServerConnection obtainServerNIOConnection(ServerSocketChannel channel) {
        TCPNIOServerConnection connection = new TCPNIOServerConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    void configureChannel(SocketChannel channel) throws IOException {
        Socket socket = channel.socket();
        channel.configureBlocking(false);
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_SOCKET_LINGER_EXCEPTION(this.linger), e);
        }
        try {
            socket.setKeepAlive(this.isKeepAlive());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_SOCKET_KEEPALIVE_EXCEPTION(this.isKeepAlive()), e);
        }
        try {
            socket.setTcpNoDelay(this.isTcpNoDelay());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_SOCKET_TCPNODELAY_EXCEPTION(this.isTcpNoDelay()), e);
        }
        socket.setReuseAddress(this.isReuseAddress());
    }

    @Override
    public AsyncQueueIO<SocketAddress> getAsyncQueueIO() {
        return this.asyncQueueIO;
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = null;
                this.processorSelector = null;
            }
        }
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setKeepAlive(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getServerConnectionBackLog() {
        return this.serverConnectionBackLog;
    }

    public void setServerConnectionBackLog(int serverConnectionBackLog) {
        this.serverConnectionBackLog = serverConnectionBackLog;
    }

    @Override
    public Filter getTransportFilter() {
        return this.defaultTransportFilter;
    }

    @Override
    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.temporarySelectorIO;
    }

    @Override
    public void fireIOEvent(IOEvent ioEvent, Connection connection, IOEventLifeCycleListener listener) {
        if (ioEvent == IOEvent.SERVER_ACCEPT) {
            try {
                ((TCPNIOServerConnection)connection).onAccept();
            }
            catch (IOException e) {
                TCPNIOTransport.failProcessingHandler(ioEvent, connection, listener, e);
            }
            return;
        }
        if (ioEvent == IOEvent.CLIENT_CONNECTED) {
            try {
                ((TCPNIOConnection)connection).onConnect();
            }
            catch (IOException e) {
                TCPNIOTransport.failProcessingHandler(ioEvent, connection, listener, e);
            }
            return;
        }
        ProcessorExecutor.execute(Context.create(connection, connection.obtainProcessor(ioEvent), ioEvent, listener));
    }

    @Override
    public Reader<SocketAddress> getReader(Connection connection) {
        return this.getReader(connection.isBlocking());
    }

    @Override
    public Reader<SocketAddress> getReader(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getReader();
        }
        return this.getAsyncQueueIO().getReader();
    }

    @Override
    public Writer<SocketAddress> getWriter(Connection connection) {
        return this.getWriter(connection.isBlocking());
    }

    @Override
    public Writer<SocketAddress> getWriter(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getWriter();
        }
        return this.getAsyncQueueIO().getWriter();
    }

    public Buffer read(Connection connection, Buffer buffer) throws IOException {
        boolean isAllocate;
        TCPNIOConnection tcpConnection = (TCPNIOConnection)connection;
        boolean bl = isAllocate = buffer == null;
        if (isAllocate) {
            int read;
            try {
                buffer = TCPNIOUtils.allocateAndReadBuffer(tcpConnection);
                read = buffer.position();
                tcpConnection.onRead(buffer, read);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "TCPNIOConnection (" + connection + ") (allocated) read exception", e);
                }
                read = -1;
            }
            if (read == 0) {
                buffer = null;
            } else if (read < 0) {
                EOFException e = new EOFException();
                tcpConnection.close0(null, new CloseReason(CloseType.REMOTELY, e));
                throw e;
            }
        } else if (buffer.hasRemaining()) {
            int read;
            try {
                read = TCPNIOUtils.readBuffer(tcpConnection, buffer);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "TCPNIOConnection (" + connection + ") (existing) read exception", e);
                }
                read = -1;
            }
            tcpConnection.onRead(buffer, read);
            if (read < 0) {
                EOFException e = new EOFException();
                tcpConnection.close0(null, new CloseReason(CloseType.REMOTELY, e));
                throw e;
            }
        }
        return buffer;
    }

    public int write(TCPNIOConnection connection, WritableMessage message) throws IOException {
        return this.write(connection, message, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(TCPNIOConnection connection, WritableMessage message, WriteResult currentResult) throws IOException {
        if (message.remaining() == 0) {
            return 0;
        }
        if (message instanceof Buffer) {
            Buffer buffer = (Buffer)message;
            try {
                int written = buffer.isComposite() ? TCPNIOUtils.writeCompositeBuffer(connection, (CompositeBuffer)buffer) : TCPNIOUtils.writeSimpleBuffer(connection, buffer);
                boolean hasWritten = written >= 0;
                connection.onWrite(buffer, written);
                if (!hasWritten) return written;
                if (currentResult == null) return written;
                currentResult.setMessage(message);
                currentResult.setWrittenSize(currentResult.getWrittenSize() + (long)written);
                currentResult.setDstAddressHolder(connection.peerSocketAddressHolder);
                return written;
            }
            catch (IOException e) {
                connection.close0(null, new CloseReason(CloseType.REMOTELY, e));
                throw e;
            }
        } else {
            if (!(message instanceof FileTransfer)) throw new IllegalStateException("Unhandled message type");
            return (int)((FileTransfer)message).writeTo((SocketChannel)connection.getChannel());
        }
    }

    private static void failProcessingHandler(IOEvent ioEvent, Connection connection, IOEventLifeCycleListener processingHandler, IOException e) {
        if (processingHandler != null) {
            try {
                processingHandler.onError(Context.create(connection, null, ioEvent, processingHandler), e);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    @Override
    protected Object createJmxManagementObject() {
        return MonitoringUtils.loadJmxObject("org.glassfish.grizzly.nio.transport.jmx.TCPNIOTransport", this, TCPNIOTransport.class);
    }

    class TransportConnectorHandler
    extends TCPNIOConnectorHandler {
        public TransportConnectorHandler() {
            super(TCPNIOTransport.this);
        }

        @Override
        public Processor getProcessor() {
            return TCPNIOTransport.this.getProcessor();
        }

        @Override
        public ProcessorSelector getProcessorSelector() {
            return TCPNIOTransport.this.getProcessorSelector();
        }
    }

    class RegisterChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        RegisterChannelCompletionHandler() {
        }

        @Override
        public void completed(RegisterChannelResult result) {
            SelectionKey selectionKey = result.getSelectionKey();
            TCPNIOConnection connection = (TCPNIOConnection)TCPNIOTransport.this.getSelectionKeyHandler().getConnectionForKey(selectionKey);
            if (connection != null) {
                SelectorRunner selectorRunner = result.getSelectorRunner();
                connection.setSelectionKey(selectionKey);
                connection.setSelectorRunner(selectorRunner);
            }
        }
    }
}

