/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.security.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import net.openesb.rest.api.security.Session;
import net.openesb.rest.api.security.SessionIdGenerator;
import net.openesb.rest.api.security.SessionManager;

public class DefaultSessionManager
implements SessionManager {
    private ConcurrentMap<Serializable, Session> sessions = new ConcurrentHashMap<Serializable, Session>();
    @Inject
    private SessionIdGenerator idGenerator;

    @Override
    public Session getSession(Serializable sessionKey) {
        Session session = (Session)this.sessions.get(sessionKey);
        if (session != null) {
            try {
                session.validate();
                session.access();
                return session;
            }
            catch (Exception ex) {
                this.sessions.remove(session.getId());
            }
        }
        return null;
    }

    @Override
    public Session create(Map<String, Object> sessionContext) {
        Session session = new Session();
        Serializable sessionId = this.idGenerator.generate(session);
        session.setId(sessionId);
        this.sessions.put(session.getId(), session);
        return session;
    }
}

