/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.resources;

import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.MessageService;
import net.openesb.model.api.NMR;
import net.openesb.model.api.metric.Metric;
import net.openesb.rest.api.annotation.RequiresAuthentication;
import net.openesb.rest.api.resources.AbstractResource;
import net.openesb.rest.api.resources.ComponentResource;
import net.openesb.rest.api.resources.EndpointsResource;

@Path(value="nmr")
@RequiresAuthentication
public class MessageServiceResource
extends AbstractResource {
    @Inject
    private MessageService messageService;
    @Inject
    private ResourceContext resourceContext;

    @GET
    @Produces(value={"application/json"})
    public NMR getMessageService() throws ManagementException {
        return this.messageService.getNMR();
    }

    @GET
    @Path(value="stats")
    @Produces(value={"application/json"})
    public Map<String, Metric> getMessageServiceStatistics() throws ManagementException {
        return this.messageService.getStatistics();
    }

    @Path(value="endpoints")
    public EndpointsResource getEndpointsResource() {
        return (EndpointsResource)this.resourceContext.initResource((Object)new EndpointsResource());
    }

    @Path(value="{component}")
    public ComponentResource getComponentResource(@PathParam(value="component") String componentName) {
        return (ComponentResource)this.resourceContext.initResource((Object)new ComponentResource(componentName));
    }
}

