/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.provider;

import java.io.IOException;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

@Provider
public class ObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper defaultObjectMapper = ObjectMapperProvider.createDefaultMapper();

    public ObjectMapper getContext(Class<?> type) {
        return this.defaultObjectMapper;
    }

    private static ObjectMapper createDefaultMapper() {
        JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        mapper.setDeserializationConfig(mapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)jaxbIntrospector));
        mapper.setSerializationConfig(mapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)jaxbIntrospector));
        SimpleModule customModule = new SimpleModule("OpenesbModule", new Version(1, 0, 0, null));
        customModule.addSerializer((JsonSerializer)new QNameSerializer());
        mapper.registerModule((Module)customModule);
        return mapper;
    }

    public static class QNameSerializer
    extends JsonSerializer<QName> {
        public void serialize(QName value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("namespaceURI", value.getNamespaceURI());
            jgen.writeStringField("localPart", value.getLocalPart());
            jgen.writeEndObject();
        }

        public Class<QName> handledType() {
            return QName.class;
        }
    }
}

