/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.provider;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.openesb.management.api.ManagementException;
import net.openesb.model.api.manage.ComponentTask;
import net.openesb.model.api.manage.Task;

@Provider
public class ManagementExceptionMapper
implements ExceptionMapper<ManagementException> {
    public Response toResponse(ManagementException me) {
        String message = me.getMessage();
        if (me.getTask() != null) {
            message = this.buildTaskError(me.getTask());
        }
        return Response.serverError().entity((Object)message).build();
    }

    private String buildTaskError(Task task) {
        if (task.getFrameworkTask() != null) {
            if (!task.getFrameworkTask().getResult().getTaskStatusMsg().isEmpty()) {
                return (String)task.getFrameworkTask().getResult().getTaskStatusMsg().get(0);
            }
            return (String)task.getFrameworkTask().getResult().getErrorMsg().get(0);
        }
        return (String)((ComponentTask)task.getComponentsTask().iterator().next()).getResult().getTaskStatusMsg().get(0);
    }
}

