/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.rest.api.inject;

import java.io.Serializable;
import javax.inject.Inject;
import javax.ws.rs.core.HttpHeaders;
import net.openesb.rest.api.security.Session;
import net.openesb.rest.api.security.SessionManager;
import org.glassfish.hk2.api.Factory;

public class SessionInjectResolver
implements Factory<Session> {
    private final HttpHeaders request;
    private final SessionManager sessionManager;

    @Inject
    public SessionInjectResolver(HttpHeaders request, SessionManager sessionManager) {
        this.request = request;
        this.sessionManager = sessionManager;
    }

    public Session provide() {
        String authHeader = this.request.getHeaderString("authorization");
        if (authHeader != null) {
            String token = SessionInjectResolver.decode(authHeader);
            return this.sessionManager.getSession((Serializable)((Object)token));
        }
        return null;
    }

    public void dispose(Session t) {
    }

    private static String decode(String auth) {
        return auth.replaceFirst("[T|t]oken ", "");
    }
}

