/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.jmx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import net.openesb.management.api.ManagementException;
import net.openesb.management.api.MessageService;
import net.openesb.management.jmx.AbstractServiceImpl;
import net.openesb.model.api.NMR;
import net.openesb.model.api.Statistic;
import net.openesb.model.api.metric.Metric;

public class MessageServiceImpl
extends AbstractServiceImpl
implements MessageService {
    public NMR getNMR() throws ManagementException {
        NMR info = new NMR();
        info.setEndpointCount(this.getMessageServiceMBean().getActiveEndpointCount());
        info.setChannels(Arrays.asList(this.getMessageServiceMBean().getActiveChannels()));
        return info;
    }

    public Map<String, Metric> getStatistics() {
        CompositeData compData = this.getMessageServiceStatisticsMBean().getMessagingStatistics();
        CompositeType compType = compData.getCompositeType();
        HashMap<String, Statistic> statistics = new HashMap<String, Statistic>(compType.keySet().size());
        for (String statKey : compType.keySet()) {
            Object value = compData.get(statKey);
            String description = compType.getDescription(statKey);
            statistics.put(statKey, new Statistic(statKey, value, description));
        }
        return Collections.unmodifiableMap(statistics);
    }
}

