/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.sdk;

import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.openesb.sdk.Request;
import net.openesb.sdk.http.HttpMethodName;

public class DefaultRequest<T>
implements Request<T> {
    private String resourcePath;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private URI endpoint;
    private HttpMethodName httpMethod = HttpMethodName.POST;
    private InputStream content;

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public Request<T> withParameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    @Override
    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public void setContent(InputStream content) {
        this.content = content;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    public String toString() {
        String value;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHttpMethod().toString()).append(" ");
        builder.append(this.getEndpoint().toString()).append(" ");
        builder.append("/").append(this.getResourcePath() != null ? this.getResourcePath() : "").append(" ");
        if (!this.getParameters().isEmpty()) {
            builder.append("Parameters: (");
            for (String key : this.getParameters().keySet()) {
                value = this.getParameters().get(key);
                builder.append(key).append(": ").append(value).append(", ");
            }
            builder.append(") ");
        }
        if (!this.getHeaders().isEmpty()) {
            builder.append("Headers: (");
            for (String key : this.getHeaders().keySet()) {
                value = this.getHeaders().get(key);
                builder.append(key).append(": ").append(value).append(", ");
            }
            builder.append(") ");
        }
        return builder.toString();
    }
}

