/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.openesb.model.api.ApplicationVariable;

public final class ApplicationVariableConverter {
    private static final Pattern APP_VARIABLE_PATTERN = Pattern.compile("(\\[(boolean|string|number|password)\\])?(.+)", 2);

    private ApplicationVariableConverter() {
    }

    public static ApplicationVariable convert(String key, String inputValue) {
        Matcher matcher;
        if (inputValue.startsWith("\"") && inputValue.endsWith("\"")) {
            inputValue = inputValue.substring(1, inputValue.length() - 1);
        }
        if ((matcher = APP_VARIABLE_PATTERN.matcher(inputValue)).matches()) {
            ApplicationVariable appVariable = new ApplicationVariable();
            appVariable.setName(key.trim());
            if (matcher.group(1) != null) {
                String type = matcher.group(1);
                String value = matcher.group(0);
                value = value.substring(value.lastIndexOf("]") + 1);
                type = type.substring(1, type.length() - 1).toUpperCase();
                appVariable.setType(type);
                appVariable.setValue(value);
            } else {
                appVariable.setValue(matcher.group(0));
                appVariable.setType("STRING");
            }
            return appVariable;
        }
        return null;
    }
}

