/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.command.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.FileConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Set;
import net.openesb.command.Command;
import net.openesb.command.CommandException;
import net.openesb.command.utils.CLITokenizer;
import net.openesb.command.utils.I18NBundle;
import net.openesb.command.utils.OutputUtils;
import net.openesb.model.api.NameValuePair;
import net.openesb.sdk.OpenESBClient;
import net.openesb.sdk.OpenESBClientException;
import net.openesb.sdk.http.OpenESBClientImpl;
import net.openesb.sdk.model.LoginRequest;
import net.openesb.sdk.model.LogoutRequest;

public abstract class AbstractCommand
implements Command {
    @Parameter(names={"--user", "-u"}, descriptionKey="cli.inherited.param.user", arity=1)
    private String userName;
    @Parameter(names={"--passwordfile"}, descriptionKey="cli.inherited.param.passwordfile", converter=FileConverter.class, arity=1)
    private File passwordFile;
    @Parameter(names={"--host", "-H"}, descriptionKey="cli.inherited.param.host", arity=1)
    private String host = "localhost";
    @Parameter(names={"--port", "-p"}, descriptionKey="cli.inherited.param.port", arity=1)
    private int port = 4848;
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    private static OpenESBClient client;

    protected synchronized OpenESBClient getClient() {
        if (client == null) {
            client = this.initClient();
        }
        return client;
    }

    private OpenESBClient initClient() {
        String url = String.format("http://%s:%s/api", this.host, this.port);
        return new OpenESBClientImpl(url);
    }

    protected String getLocalizedString(String key, Object[] args) {
        return I18NBundle.getBundle().getMessage(key, args);
    }

    protected String getLocalizedString(String key, Object arg) {
        return I18NBundle.getBundle().getMessage(key, arg);
    }

    protected String getLocalizedString(String key) {
        return this.getLocalizedString(key, null);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public File getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(File passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected void printMessage(String message) {
        System.out.println(message);
    }

    protected void displayOptionHeader(String bundleKey, int indention) {
        String msg = this.getLocalizedString(bundleKey);
        this.displayHeader(msg, indention);
    }

    protected void displayHeader(String headerString, int indention) {
        OutputUtils.displayMessage(" ", 0);
        OutputUtils.displayMessage(headerString, indention);
        String underline = OutputUtils.createFillString('-', headerString.length());
        OutputUtils.displayMessage(underline, indention);
    }

    protected void displayDescriptor(String descriptor) {
        OutputUtils.displayMessage(descriptor, 0);
    }

    protected Properties createPropertiesParam(String propertyStr) throws CommandException {
        if (propertyStr == null) {
            return null;
        }
        Properties properties = new Properties();
        CLITokenizer propertyTok = new CLITokenizer(propertyStr, ",");
        while (propertyTok.hasMoreTokens()) {
            String nameAndvalue = propertyTok.nextToken();
            CLITokenizer nameTok = new CLITokenizer(nameAndvalue, "=");
            if (nameTok.countTokens() == 2) {
                properties.setProperty(nameTok.nextTokenWithoutEscapeAndQuoteChars(), nameTok.nextTokenWithoutEscapeAndQuoteChars());
                continue;
            }
            throw new CommandException("InvalidPropertySyntax");
        }
        return properties;
    }

    protected void displayNameValuePairs(Set<? extends NameValuePair<?>> pairs, int indentAmount) {
        for (NameValuePair<?> pair : pairs) {
            String outputString = OutputUtils.createFillString(' ', indentAmount) + pair.getName() + " = " + pair.getValue();
            this.printMessage(outputString);
        }
    }

    @Override
    public boolean execute() {
        try {
            this.getClient().login(new LoginRequest(this.getUserName(), this.readPassword()));
            this.executeRequest();
            this.getClient().logout(new LogoutRequest());
        }
        catch (OpenESBClientException oex) {
            this.printMessage(oex.getMessage());
            return false;
        }
        catch (Exception e) {
            this.printMessage(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean help() {
        return this.help;
    }

    private String readPassword() {
        String password = this.readPasswordFromFile();
        if (password == null) {
            password = new String(this.readPasswordFromConsole());
        }
        return password;
    }

    private String readPasswordFromFile() {
        if (this.passwordFile != null && this.passwordFile.exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(this.passwordFile));
                return properties.getProperty("OE_ADMIN_PASSWORD");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public char[] readPasswordFromConsole() {
        try {
            System.out.print("Password: ");
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader in = new BufferedReader(isr);
            String result = in.readLine();
            in.close();
            isr.close();
            return result.toCharArray();
        }
        catch (IOException e) {
            throw new ParameterException(e);
        }
    }

    protected abstract void executeRequest() throws Exception;
}

