/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.management.api;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.openesb.management.api.AdministrationService;
import net.openesb.management.api.ComponentService;
import net.openesb.management.api.ConfigurationService;
import net.openesb.management.api.EndpointService;
import net.openesb.management.api.JvmMetricsService;
import net.openesb.management.api.MessageService;
import net.openesb.management.api.ServiceAssemblyService;
import net.openesb.management.api.SharedLibraryService;
import net.openesb.management.api.StatisticsService;

public final class ManagementFactory {
    private static final Logger logger = Logger.getLogger(ManagementFactory.class.getName());
    private static ServiceAssemblyService serviceAssemblyService;
    private static SharedLibraryService sharedLibraryService;
    private static ComponentService componentService;
    private static EndpointService endpointService;
    private static AdministrationService administrationService;
    private static MessageService messageService;
    private static StatisticsService statisticsService;
    private static ConfigurationService configurationService;
    private static JvmMetricsService jvmMetricsService;

    private ManagementFactory() {
    }

    public static synchronized ServiceAssemblyService getServiceAssemblyService() {
        if (serviceAssemblyService == null) {
            logger.log(Level.FINEST, "Construct instance of ServiceAssemblyService.");
            serviceAssemblyService = (ServiceAssemblyService)ManagementFactory.constructInstance("net.openesb.management.jmx.ServiceAssemblyServiceImpl");
        }
        return serviceAssemblyService;
    }

    public static synchronized SharedLibraryService getSharedLibraryService() {
        if (sharedLibraryService == null) {
            logger.log(Level.FINEST, "Construct instance of SharedLibraryService.");
            sharedLibraryService = (SharedLibraryService)ManagementFactory.constructInstance("net.openesb.management.jmx.SharedLibraryServiceImpl");
        }
        return sharedLibraryService;
    }

    public static synchronized ComponentService getComponentService() {
        if (componentService == null) {
            logger.log(Level.FINEST, "Construct instance of ComponentService.");
            componentService = (ComponentService)ManagementFactory.constructInstance("net.openesb.management.jmx.ComponentServiceImpl");
        }
        return componentService;
    }

    public static synchronized EndpointService getEndpointService() {
        if (endpointService == null) {
            logger.log(Level.FINEST, "Construct instance of EndpointService.");
            endpointService = (EndpointService)ManagementFactory.constructInstance("net.openesb.management.jmx.EndpointServiceImpl");
        }
        return endpointService;
    }

    public static synchronized AdministrationService getAdministrationService() {
        if (administrationService == null) {
            logger.log(Level.FINEST, "Construct instance of AdministrationService.");
            administrationService = (AdministrationService)ManagementFactory.constructInstance("net.openesb.management.jmx.AdministrationServiceImpl");
        }
        return administrationService;
    }

    public static synchronized MessageService getMessageService() {
        if (messageService == null) {
            logger.log(Level.FINEST, "Construct instance of MessageService.");
            messageService = (MessageService)ManagementFactory.constructInstance("net.openesb.management.jmx.MessageServiceImpl");
        }
        return messageService;
    }

    public static synchronized StatisticsService getStatisticsService() {
        if (statisticsService == null) {
            logger.log(Level.FINEST, "Construct instance of StatisticsService.");
            statisticsService = (StatisticsService)ManagementFactory.constructInstance("net.openesb.management.jmx.StatisticsServiceImpl");
        }
        return statisticsService;
    }

    public static synchronized ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            logger.log(Level.FINEST, "Construct instance of ConfigurationService.");
            configurationService = (ConfigurationService)ManagementFactory.constructInstance("net.openesb.management.jmx.ConfigurationServiceImpl");
        }
        return configurationService;
    }

    public static synchronized JvmMetricsService getJvmMetricsService() {
        if (jvmMetricsService == null) {
            logger.log(Level.FINEST, "Construct instance of JvmMetricsService.");
            jvmMetricsService = (JvmMetricsService)ManagementFactory.constructInstance("net.openesb.management.jmx.JvmMetricsServiceImpl");
        }
        return jvmMetricsService;
    }

    private static <T> T constructInstance(String serviceClassname) {
        try {
            logger.log(Level.FINE, "Creating instance of {0}", serviceClassname);
            Object _instance = Class.forName(serviceClassname).newInstance();
            logger.log(Level.FINE, "An instance of {0} has been succesfully created: {1}", new Object[]{serviceClassname, _instance});
            return (T)_instance;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to create " + serviceClassname, e);
            return null;
        }
    }
}

