/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.openesb.standalone.settings.Settings;
import net.openesb.standalone.settings.SettingsException;

public class ImmutableSettings
implements Settings {
    private final Map<String, String> settings;

    public ImmutableSettings(Map<String, String> settings) {
        this.settings = settings != null ? Collections.unmodifiableMap(settings) : Collections.unmodifiableMap(new HashMap());
    }

    @Override
    public String get(String setting) {
        String retVal = this.settings.get(setting);
        if (retVal != null) {
            return retVal;
        }
        return null;
    }

    @Override
    public String get(String setting, String defaultValue) {
        String retVal = this.get(setting);
        return retVal == null ? defaultValue : retVal;
    }

    @Override
    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        return ImmutableSettings.parseBoolean(this.get(setting), defaultValue);
    }

    @Override
    public Integer getAsInt(String setting, Integer defaultValue) throws SettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return !value.equals("false") && !value.equals("0") && !value.equals("off") && !value.equals("no");
    }

    public static Boolean parseBoolean(String value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return !value.equals("false") && !value.equals("0") && !value.equals("off") && !value.equals("no");
    }

    @Override
    public Object getAsObject(String setting) throws SettingsException {
        return this.settings.get(setting);
    }
}

