/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.rest.filter;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.DatatypeConverter;
import net.openesb.security.AuthenticationException;
import net.openesb.security.AuthenticationToken;
import net.openesb.security.SecurityProvider;
import net.openesb.security.UsernamePasswordToken;

@Provider
@PreMatching
public class ContainerBasedAuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(ContainerBasedAuthenticationFilter.class.getName());
    @Inject
    private SecurityProvider securityProvider;

    public void filter(ContainerRequestContext requestCtx) throws IOException {
        if (requestCtx.getRequest().getMethod().equals("OPTIONS")) {
            requestCtx.abortWith(Response.status((Response.Status)Response.Status.OK).build());
        } else {
            String usernamePassword;
            String username = "";
            String password = "";
            String authorization = requestCtx.getHeaderString("authorization");
            if (null != authorization && authorization.length() > "Basic ".length() && (usernamePassword = new String(DatatypeConverter.parseBase64Binary((String)authorization.substring("Basic ".length())))).contains(":")) {
                username = usernamePassword.substring(0, usernamePassword.indexOf(":"));
                if (usernamePassword.indexOf(":") + 1 < usernamePassword.length()) {
                    password = usernamePassword.substring(usernamePassword.indexOf(":") + 1);
                }
            }
            try {
                this.securityProvider.login((AuthenticationToken)new UsernamePasswordToken(username, password));
            }
            catch (AuthenticationException aex) {
                log.log(Level.SEVERE, "Unexpected error while login: {0}", aex.getMessage());
                requestCtx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                return;
            }
            String requestUriPath = requestCtx.getUriInfo().getRequestUri().getPath();
            if (requestUriPath.endsWith("/login")) {
                requestCtx.abortWith(Response.status((Response.Status)Response.Status.OK).build());
                return;
            }
        }
    }
}

