/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.plugins.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import net.openesb.standalone.plugins.PluginInfo;

public class PluginsModule
extends Module {
    static final Version VERSION = new Version(1, 0, 0, "", "net.open-esb.standalone", "plugins-module");

    public String getModuleName() {
        return "plugins-module";
    }

    public Version version() {
        return VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)new SimpleSerializers(Arrays.asList(new JsonSerializer[]{new PluginInfoSerializer()})));
    }

    private static class PluginInfoSerializer
    extends StdSerializer<PluginInfo> {
        private PluginInfoSerializer() {
            super(PluginInfo.class);
        }

        public void serialize(PluginInfo pluginInfo, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            try {
                json.writeObjectField("name", (Object)pluginInfo.name());
                json.writeObjectField("description", (Object)pluginInfo.description());
                json.writeObjectField("version", (Object)pluginInfo.version());
            }
            catch (RuntimeException e) {
                json.writeObjectField("error", (Object)e.toString());
            }
            json.writeEndObject();
        }
    }
}

