/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import net.openesb.standalone.Lifecycle;
import net.openesb.standalone.LifecycleException;
import net.openesb.standalone.settings.Settings;
import net.openesb.standalone.utils.I18NBundle;

public class JMXService
implements Lifecycle {
    private static final Logger LOG = Logger.getLogger(JMXService.class.getName());
    public static final String CONNECTOR_PORT = "instance.port";
    @Inject
    private Settings settings;
    @Inject
    private JMXAuthenticator authenticator;
    private MBeanServer server;
    private boolean threaded;
    private boolean daemon;
    private String serviceUrl;
    private JMXConnectorServer connectorServer;

    @Override
    public void start() {
        if (this.server == null) {
            this.server = MBeanServerHolder.INSTANCE;
        }
        this.serviceUrl = String.format("service:jmx:rmi:///jndi/rmi://localhost:%s/jmxrmi", this.getPort());
        JMXServiceURL url = null;
        try {
            url = new JMXServiceURL(this.serviceUrl);
        }
        catch (MalformedURLException murle) {
            throw new LifecycleException("Unable to create JMX connector", murle);
        }
        if (this.serviceUrl.contains("localhost") && url.getProtocol().compareToIgnoreCase("rmi") == 0) {
            try {
                int registryPort = this.getURLLocalHostPort(this.serviceUrl);
                try {
                    LocateRegistry.createRegistry(registryPort);
                }
                catch (Exception ex) {
                    LocateRegistry.getRegistry(registryPort);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("CONNECTOR_CREATE_REGISTRY_FAILURE"), ex);
            }
        }
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("jmx.remote.authenticator", this.authenticator);
        environment.put("com.sun.management.jmxremote.authenticate", Boolean.TRUE.toString());
        try {
            this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, environment, this.server);
        }
        catch (IOException ioe) {
            throw new LifecycleException("Unable to create JMX connector", ioe);
        }
        if (this.threaded) {
            Thread connectorThread = new Thread(){

                @Override
                public void run() {
                    try {
                        JMXService.this.connectorServer.start();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("CONNECTOR_START_CONNECTOR_FAILURE", JMXService.this.serviceUrl), ex);
                    }
                }
            };
            connectorThread.setName("JMX Connector Thread [" + this.connectorServer.getAddress() + "]");
            connectorThread.setDaemon(this.daemon);
            connectorThread.start();
        } else {
            try {
                this.connectorServer.start();
            }
            catch (IOException ioe) {
                throw new LifecycleException("Unable to start JMX connector", ioe);
            }
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("CONNECTOR_START_CONNECTOR_STARTED", this.connectorServer.getAddress()));
        }
    }

    @Override
    public void stop() {
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("CONNECTOR_SERVER_CONNECTOR_STOPPED"));
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("CONTAINER_SHUTDOWN_ERROR"), ioe);
                throw new LifecycleException(I18NBundle.getBundle().getMessage("CONTAINER_SHUTDOWN_ERROR"), ioe);
            }
        }
    }

    private int getURLLocalHostPort(String url) {
        int portEnd;
        int portStart = url.indexOf("localhost") + 10;
        int port = 0;
        if (portStart > 0 && (portEnd = JMXService.indexNotOfNumber(url, portStart)) > portStart) {
            String portString = url.substring(portStart, portEnd);
            port = Integer.parseInt(portString);
        }
        return port;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    private static int indexNotOfNumber(String str, int index) {
        int i = 0;
        for (i = index; i < str.length(); ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
            return i;
        }
        return -1;
    }

    public MBeanServer getMBeanServer() {
        return MBeanServerHolder.INSTANCE;
    }

    public int getPort() {
        try {
            return this.settings.getAsInt(CONNECTOR_PORT, 8699);
        }
        catch (NumberFormatException nfEx) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("CONNECTOR_SERVER_INVALID_PORT", 8699), nfEx);
            return 8699;
        }
    }

    private static class MBeanServerHolder {
        private static final MBeanServer INSTANCE = ManagementFactory.getPlatformMBeanServer();

        private MBeanServerHolder() {
        }
    }
}

