/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.framework;

import com.sun.jbi.JBIProvider;
import com.sun.jbi.platform.PlatformEventListener;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import net.openesb.security.SecurityProvider;
import net.openesb.standalone.framework.KeyStoreUtil;
import net.openesb.standalone.jmx.JMXService;
import net.openesb.standalone.node.Node;

public class PlatformContext
implements com.sun.jbi.platform.PlatformContext {
    @Inject
    private JMXService jmxConnector;
    @Inject
    private SecurityProvider securityProvider;
    @Inject
    private TransactionManager transactionManager;
    @Inject
    private InitialContext namingContext;
    @Inject
    private Node node;
    private final com.sun.jbi.security.KeyStoreUtil keyStoreUtil = new KeyStoreUtil();
    private final String mInstallRoot = System.getProperty("openesb.work", System.getProperty("openesb.home"));

    public TransactionManager getTransactionManager() throws Exception {
        return this.transactionManager;
    }

    public MBeanServerConnection getMBeanServerConnection(String instanceName) throws Exception {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public String getAdminServerName() {
        return this.node.name();
    }

    public boolean isAdminServer() {
        return true;
    }

    public String getInstanceName() {
        return this.node.name();
    }

    public boolean isInstanceUp(String instanceName) {
        return this.node.name().equals(instanceName);
    }

    public boolean supportsMultipleServers() {
        return false;
    }

    public String getTargetName() {
        return this.node.name();
    }

    public String getTargetName(String instanceName) {
        return instanceName;
    }

    public Set<String> getStandaloneServerNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(this.node.name());
        return names;
    }

    public Set<String> getClusteredServerNames() {
        return new HashSet<String>();
    }

    public Set<String> getClusterNames() {
        return new HashSet<String>();
    }

    public Set<String> getServersInCluster(String clusterName) {
        return new HashSet<String>();
    }

    public boolean isValidTarget(String targetName) {
        return this.node.name().equals(targetName);
    }

    public boolean isCluster(String targetName) {
        return false;
    }

    public boolean isStandaloneServer(String targetName) {
        return this.node.name().equals(targetName);
    }

    public boolean isClusteredServer(String targetName) {
        return false;
    }

    public boolean isInstanceClustered(String instanceName) {
        return false;
    }

    public String getJmxRmiPort() {
        return Integer.toString(this.jmxConnector.getPort());
    }

    public MBeanServer getMBeanServer() {
        return this.jmxConnector.getMBeanServer();
    }

    public String getInstanceRoot() {
        return this.mInstallRoot + File.separator + this.node.name();
    }

    public String getInstallRoot() {
        return this.mInstallRoot;
    }

    public JBIProvider getProvider() {
        return JBIProvider.JSE;
    }

    public com.sun.jbi.security.KeyStoreUtil getKeyStoreUtil() {
        return this.keyStoreUtil;
    }

    public InitialContext getNamingContext() {
        return this.namingContext;
    }

    public ClassLoader getSystemClassLoader() throws SecurityException {
        return this.getClass().getClassLoader().getParent();
    }

    public void addListener(PlatformEventListener listener) {
    }

    public void removeListener(PlatformEventListener listener) {
    }

    public Level getJbiLogLevel(String target) {
        Level jbiLoggerLevel = Logger.getLogger("com.sun.jbi").getLevel();
        if (jbiLoggerLevel == null) {
            jbiLoggerLevel = Level.INFO;
        }
        return jbiLoggerLevel;
    }

    public void setJbiLogLevel(String target, Level level) {
        Logger.getLogger("com.sun.jbi").setLevel(level);
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }
}

