/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.security;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.security.auth.Subject;
import net.openesb.security.AuthenticationException;
import net.openesb.security.AuthenticationToken;
import net.openesb.security.SecurityProvider;
import net.openesb.standalone.security.realm.Realm;
import net.openesb.standalone.security.realm.RealmBuilder;
import net.openesb.standalone.security.realm.shiro.ShiroAuthenticator;
import net.openesb.standalone.settings.Settings;
import net.openesb.standalone.utils.I18NBundle;

public class SecurityProviderImpl
implements SecurityProvider {
    private static final Logger LOG = Logger.getLogger(SecurityProviderImpl.class.getName());
    private static final String SETTINGS_KEY = "realm";
    private final Map<String, Realm> realms = new HashMap<String, Realm>();
    private final ShiroAuthenticator authenticator = new ShiroAuthenticator();

    @Inject
    public SecurityProviderImpl(Settings settings) {
        this.init(settings);
    }

    private void init(Settings settings) {
        try {
            Map realmsConfiguration = (Map)settings.getAsObject(SETTINGS_KEY);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("SECURITY_LOAD_CONFIGURATION"));
            }
            for (Map.Entry realmConfig : realmsConfiguration.entrySet()) {
                String realmName = (String)realmConfig.getKey();
                if (!this.realms.containsKey(realmName)) {
                    Realm realm = RealmBuilder.realmBuilder().build(realmName, (Map)realmConfig.getValue());
                    this.authenticator.loadRealm(realm);
                    this.realms.put(realmName, realm);
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    if (realm.getName().equals("management")) {
                        LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("SECURITY_ADMIN_REALM_CONFIGURED", realmName));
                        continue;
                    }
                    LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("SECURITY_USER_REALM_CONFIGURED", realmName));
                    continue;
                }
                LOG.log(Level.WARNING, I18NBundle.getBundle().getMessage("SECURITY_USER_REALM_ALREADY_DEFINED", realmName));
            }
        }
        catch (NullPointerException npe) {
            LOG.log(Level.WARNING, I18NBundle.getBundle().getMessage("SECURITY_NO_REALM"));
        }
    }

    public Collection<String> getRealms() {
        return Collections.unmodifiableSet(this.realms.keySet());
    }

    public Subject login(String realmName, AuthenticationToken authenticationToken) throws AuthenticationException {
        return this.authenticator.authenticate(realmName, authenticationToken);
    }

    public Subject login(AuthenticationToken authenticationToken) throws AuthenticationException {
        return this.login("management", authenticationToken);
    }
}

