/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.naming.jndi.ds.tomcat;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.bind.JAXBElement;
import net.openesb.standalone.naming.jaxb.DataSourcePoolProperties;
import net.openesb.standalone.naming.jaxb.DataSourceProperties;
import net.openesb.standalone.naming.jaxb.PoolProperties;
import net.openesb.standalone.naming.jaxb.Property;
import net.openesb.standalone.naming.jndi.ds.DataSourcePoolFactory;
import net.openesb.standalone.utils.I18NBundle;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.XADataSource;

public class TomcatDataSourcePoolFactory
implements DataSourcePoolFactory {
    private static final Logger LOG = Logger.getLogger(TomcatDataSourcePoolFactory.class.getName());

    @Override
    public javax.sql.DataSource getDataSource(DataSourcePoolProperties dspProperties) {
        try {
            org.apache.tomcat.jdbc.pool.PoolProperties poolProperties = this.createNativeDataSource(dspProperties);
            DataSource ds = new DataSource((PoolConfiguration)poolProperties);
            ds.setName(dspProperties.getDbConnectorName());
            this.registerMBean(ds);
            return ds;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_UNABLE_TO_CREATE_DATASOURCE", dspProperties.getDbConnectorName()), ex);
            return null;
        }
    }

    @Override
    public javax.sql.XADataSource getXADataSource(DataSourcePoolProperties dspProperties) {
        try {
            org.apache.tomcat.jdbc.pool.PoolProperties poolProperties = this.createNativeDataSource(dspProperties);
            XADataSource ds = new XADataSource((PoolConfiguration)poolProperties);
            ds.setName(dspProperties.getDbConnectorName());
            this.registerMBean((DataSource)ds);
            return ds;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_UNABLE_TO_CREATE_DATASOURCE", dspProperties.getDbConnectorName()), ex);
            return null;
        }
    }

    private void registerMBean(DataSource ds) throws Exception {
        ds.createPool();
        try {
            ds.setJmxEnabled(true);
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            String mBeanName = "net.open-esb.standalone:type=DataSources,name=" + ds.getName();
            mBeanServer.registerMBean(ds.getPool().getJmxPool(), new ObjectName(mBeanName));
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_UNABLE_TO_CREATE_MBEAN", ds.getName()), ex);
        }
    }

    private org.apache.tomcat.jdbc.pool.PoolProperties createNativeDataSource(DataSourcePoolProperties dspProperties) throws Exception {
        Object nativeDS;
        Class<?> dsClass;
        DataSourceProperties dataSourceProperties = dspProperties.getDataSourceProperties();
        Map<String, String> datasourceMap = this.listToMap(dataSourceProperties.getProperty());
        String dsName = dspProperties.getDatasourceClassname();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("DS_CREATE_DATASOURCE", dspProperties.getDbConnectorName()));
        }
        try {
            dsClass = Class.forName(dsName);
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_CLASS_NOT_FOUND", dsName, dspProperties.getDbConnectorName()));
            throw ex;
        }
        Map<String, Field> dsFields = this.getAllFields(dsClass);
        try {
            nativeDS = dsClass.newInstance();
        }
        catch (InstantiationException ex) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_UNABLE_TO_INSTANCIATE_CLASS", dsName, dspProperties.getDbConnectorName()));
            throw ex;
        }
        catch (IllegalAccessException ex) {
            LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_UNABLE_TO_ACCESS_CLASS", dsName, dspProperties.getDbConnectorName()));
            throw ex;
        }
        Set<String> dspSet = datasourceMap.keySet();
        for (String fieldName : dspSet) {
            Field field = dsFields.get(fieldName);
            if (null == field) {
                LOG.log(Level.WARNING, I18NBundle.getBundle().getMessage("DS_DATASOURCE_PROPERTY_NOT_FOUND", fieldName, dspProperties.getDbConnectorName(), dsName));
                continue;
            }
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            String fieldValue = datasourceMap.get(fieldName);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("DS_DATASOURCE_PROPERTY_SET", fieldName, fieldValue, dspProperties.getDbConnectorName()));
            }
            try {
                if (field.getType().equals(Byte.TYPE)) {
                    field.set(nativeDS, Byte.parseByte(fieldValue));
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    field.set(nativeDS, Boolean.parseBoolean(fieldValue));
                    continue;
                }
                if (field.getType().equals(Character.TYPE)) {
                    field.set(nativeDS, Character.valueOf(fieldValue.charAt(0)));
                    continue;
                }
                if (field.getType().equals(Short.TYPE)) {
                    field.set(nativeDS, Short.parseShort(fieldValue));
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    field.set(nativeDS, Integer.parseInt(fieldValue));
                    continue;
                }
                if (field.getType().equals(Long.TYPE)) {
                    field.set(nativeDS, Long.parseLong(fieldValue));
                    continue;
                }
                if (field.getType().equals(Float.TYPE)) {
                    field.set(nativeDS, Float.valueOf(Float.parseFloat(fieldValue)));
                    continue;
                }
                if (field.getType().equals(Double.TYPE)) {
                    field.set(nativeDS, Double.parseDouble(fieldValue));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(nativeDS, fieldValue);
                    continue;
                }
                LOG.log(Level.WARNING, I18NBundle.getBundle().getMessage("DS_DATASOURCE_PROPERTY_NOT_SET", fieldName, field.getType(), dspProperties.getDbConnectorName()));
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_DATASOURCE_PROPERTY_INVALID_VALUE", fieldValue, fieldName));
                throw ex;
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_DATASOURCE_PROPERTY_ACCESS", fieldName));
                throw ex;
            }
            finally {
                field.setAccessible(accessible);
            }
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("DS_DATASOURCE_PROPERTIES_SETTLED", dspProperties.getDbConnectorName()));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, I18NBundle.getBundle().getMessage("DS_POOL_CONFIGURATION", dspProperties.getDbConnectorName()));
        }
        PoolProperties contextPoolProperties = dspProperties.getPoolProperties();
        Map<String, String> poolMap = this.listToMap(contextPoolProperties.getProperty());
        org.apache.tomcat.jdbc.pool.PoolProperties poolProperties = new org.apache.tomcat.jdbc.pool.PoolProperties();
        Class<?> poolPropertiesClass = poolProperties.getClass();
        Map<String, Field> poolPropertiesFields = this.getAllFields(poolPropertiesClass);
        Set<String> poolPropertiesSet = poolMap.keySet();
        for (String fieldName : poolPropertiesSet) {
            Field field = poolPropertiesFields.get(fieldName);
            if (null == field) {
                LOG.log(Level.WARNING, I18NBundle.getBundle().getMessage("DS_POOL_PROPERTY_NOT_FOUND", fieldName, dspProperties.getDbConnectorName(), dsName));
                continue;
            }
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            String fieldValue = poolMap.get(fieldName);
            try {
                if (field.getType().equals(Byte.TYPE)) {
                    field.set(poolProperties, Byte.parseByte(fieldValue));
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    field.set(poolProperties, Boolean.parseBoolean(fieldValue));
                    continue;
                }
                if (field.getType().equals(Character.TYPE)) {
                    field.set(poolProperties, Character.valueOf(fieldValue.charAt(0)));
                    continue;
                }
                if (field.getType().equals(Short.TYPE)) {
                    field.set(poolProperties, Short.parseShort(fieldValue));
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    field.set(poolProperties, Integer.parseInt(fieldValue));
                    continue;
                }
                if (field.getType().equals(Long.TYPE)) {
                    field.set(poolProperties, Long.parseLong(fieldValue));
                    continue;
                }
                if (field.getType().equals(Float.TYPE)) {
                    field.set(poolProperties, Float.valueOf(Float.parseFloat(fieldValue)));
                    continue;
                }
                if (field.getType().equals(Double.TYPE)) {
                    field.set(poolProperties, Double.parseDouble(fieldValue));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(poolProperties, fieldValue);
                    continue;
                }
                LOG.log(Level.WARNING, I18NBundle.getBundle().getMessage("DS_POOL_PROPERTY_NOT_SET", fieldName, field.getType(), dspProperties.getDbConnectorName()));
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_POOL_PROPERTY_INVALID_VALUE", fieldValue, fieldName));
                throw ex;
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.SEVERE, I18NBundle.getBundle().getMessage("DS_POOL_PROPERTY_ACCESS", fieldName));
                throw ex;
            }
            finally {
                field.setAccessible(accessible);
            }
        }
        poolProperties.setDataSource(nativeDS);
        poolProperties.setJmxEnabled(true);
        return poolProperties;
    }

    private Map<String, String> listToMap(List<Property> inputList) {
        HashMap<String, String> outputMap = new HashMap<String, String>();
        for (Property prop : inputList) {
            List<JAXBElement<String>> nameAndValueAndDescription = prop.getNameAndValueAndDescription();
            Iterator<JAXBElement<String>> it2 = nameAndValueAndDescription.iterator();
            String key = null;
            String value = null;
            while (it2.hasNext()) {
                JAXBElement<String> element = it2.next();
                String localpart = element.getName().getLocalPart();
                if ("name".equals(localpart)) {
                    key = (String)element.getValue();
                } else if ("value".equals(localpart)) {
                    value = (String)element.getValue();
                }
                outputMap.put(key, value);
            }
        }
        return outputMap;
    }

    private Map<String, Field> getAllFields(Class<?> type) {
        ArrayList<Field> listFields = new ArrayList<Field>();
        for (Class<?> c = type; c != Object.class; c = c.getSuperclass()) {
            listFields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        HashMap<String, Field> mapFields = new HashMap<String, Field>();
        for (Field field : listFields) {
            String fieldName = field.getName();
            mapFields.put(fieldName, field);
        }
        return mapFields;
    }
}

