/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.jmx.auth.login;

import javax.inject.Inject;
import javax.security.auth.Subject;
import net.openesb.security.AuthenticationException;
import net.openesb.security.AuthenticationToken;
import net.openesb.security.SecurityProvider;

public class JMXAuthenticator
implements javax.management.remote.JMXAuthenticator {
    @Inject
    private SecurityProvider securityProvider;

    @Override
    public Subject authenticate(Object credentialsObj) {
        final String[] credentials = (String[])credentialsObj;
        if (credentials == null || credentials.length != 2) {
            throw new SecurityException("Bad credentials. Unable to authenticate user.");
        }
        try {
            return this.securityProvider.login(new AuthenticationToken(){

                public Object getPrincipal() {
                    return credentials[0];
                }

                public Object getCredentials() {
                    return credentials[1].toCharArray();
                }
            });
        }
        catch (AuthenticationException ae) {
            throw new SecurityException(ae.getMessage());
        }
    }
}

