/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.framework;

import com.sun.jbi.framework.JBIFramework;
import com.sun.jbi.platform.PlatformContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.jbi.JBIException;
import net.openesb.standalone.Lifecycle;
import net.openesb.standalone.LifecycleException;
import net.openesb.standalone.settings.Settings;

public class FrameworkService
extends JBIFramework
implements Lifecycle {
    private boolean mLoaded;
    private static final Logger LOG = Logger.getLogger(FrameworkService.class.getPackage().getName());
    @Inject
    private PlatformContext platformContext;
    @Inject
    private Settings settings;

    @Override
    public void start() {
        if (this.mLoaded) {
            throw new LifecycleException("OpenESB Standalone runtime already loaded!");
        }
        System.setProperty("com.sun.jbi.home", this.platformContext.getInstallRoot());
        System.setProperty("http.port", this.settings.get("http.port", "4848"));
        System.setProperty("http.enabled", this.settings.get("http.enabled", "true"));
        System.setProperty("http.binding", this.settings.get("http.binding", "localhost"));
        try {
            this.init(this.platformContext, System.getProperties());
            this.startup(this.platformContext.getNamingContext(), "");
            this.prepare();
            this.ready(true);
            this.mLoaded = true;
        }
        catch (JBIException jbie) {
            LOG.log(Level.SEVERE, "Unable to start properly OpenESB Core", jbie);
            throw new LifecycleException("Unable to start properly OpenESB Core", jbie);
        }
    }

    @Override
    public void stop() {
        if (!this.mLoaded) {
            return;
        }
        try {
            this.shutdown();
            this.terminate();
            this.mLoaded = false;
        }
        catch (JBIException jbie) {
            LOG.log(Level.SEVERE, "Unable to stop properly OpenESB Core", jbie);
            throw new LifecycleException("Unable to stop properly OpenESB Core", jbie);
        }
    }
}

