/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.security.realm.shiro;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.openesb.security.AuthenticationException;
import net.openesb.security.AuthenticationToken;
import net.openesb.standalone.security.realm.Realm;
import net.openesb.standalone.security.realm.impl.PropertiesRealm;
import net.openesb.standalone.security.realm.shiro.RealmConverter;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;

public class ShiroAuthenticator {
    private static final Logger LOG = Logger.getLogger(ShiroAuthenticator.class.getName());
    private final Map<String, SecurityManager> securityManagers = new HashMap<String, SecurityManager>();

    public void loadRealm(Realm realm) {
        ServiceLoader<RealmConverter> converters = ServiceLoader.load(RealmConverter.class);
        for (RealmConverter converter : converters) {
            if (!converter.canHandle(realm.getClass())) continue;
            Object sRealm = converter.convert((PropertiesRealm)realm);
            DefaultSecurityManager manager = new DefaultSecurityManager(sRealm);
            if ("management".equalsIgnoreCase(realm.getName())) {
                SecurityUtils.setSecurityManager((SecurityManager)manager);
            }
            this.securityManagers.put(realm.getName(), (SecurityManager)manager);
        }
    }

    public Subject authenticate(String realmName, AuthenticationToken authenticationToken) throws AuthenticationException {
        SecurityManager securityManager = this.securityManagers.get(realmName);
        org.apache.shiro.subject.Subject currentUser = new Subject.Builder(securityManager).buildSubject();
        UsernamePasswordToken token = new UsernamePasswordToken((String)authenticationToken.getPrincipal(), (char[])authenticationToken.getCredentials());
        try {
            currentUser.login((org.apache.shiro.authc.AuthenticationToken)token);
            Subject subject = new Subject();
            return subject;
        }
        catch (org.apache.shiro.authc.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage());
        }
    }
}

