/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.startup;

import java.util.logging.LogManager;
import net.openesb.standalone.Lifecycle;
import net.openesb.standalone.node.Node;
import net.openesb.standalone.node.NodeBuilder;
import net.openesb.standalone.utils.ReflectionUtils;

public class Container
implements Lifecycle {
    private final Node node;
    private Thread shutdownHook;

    public Container() {
        NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder();
        this.node = nodeBuilder.build();
    }

    @Override
    public void start() {
        this.node.start();
        this.shutdownHook = new ContainerShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @Override
    public void stop() {
        this.node.stop();
        try {
            ReflectionUtils.invoke(LogManager.getLogManager(), "reset0", new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class ContainerShutdownHook
    extends Thread {
        private ContainerShutdownHook() {
        }

        @Override
        public void run() {
            if (Container.this.node != null) {
                Container.this.stop();
            }
        }
    }
}

