/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.naming;

import com.google.inject.Provider;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.openesb.standalone.naming.jndi.InitialContexFactoryImpl;
import net.openesb.standalone.settings.Settings;
import net.openesb.standalone.utils.I18NBundle;
import net.openesb.standalone.utils.StringUtils;

public class ContextProvider
implements Provider<InitialContext> {
    private static final Logger LOG = Logger.getLogger(ContextProvider.class.getPackage().getName());
    private static final String DEFAULT_CONTEXT_XML = "${openesb.home}/config/context.xml";
    private static final String CONTEXT_PATH = "jndi.context";
    @Inject
    private Settings settings;

    public InitialContext get() {
        String context = this.getContext();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("NAMING_CONTEXT_PATH", context));
        }
        InitialContext mNamingContext = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", InitialContexFactoryImpl.class.getName());
            File contextFile = new File(context);
            if (!contextFile.exists()) {
                String msg = I18NBundle.getBundle().getMessage("NAMING_CONTEXT_INVALID_PATH", contextFile.getAbsolutePath());
                LOG.log(Level.SEVERE, msg);
                throw new IllegalStateException(msg);
            }
            env.put("java.naming.provider.url", contextFile.toURI().toURL().toString());
            mNamingContext = new InitialContext(env);
        }
        catch (NamingException nmEx) {
            LOG.log(Level.SEVERE, "", nmEx);
        }
        catch (MalformedURLException nmEx) {
            LOG.log(Level.SEVERE, "", nmEx);
        }
        return mNamingContext;
    }

    private String getContext() {
        String context = this.settings.get(CONTEXT_PATH, DEFAULT_CONTEXT_XML);
        return StringUtils.replace(context);
    }
}

