/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.standalone.node.internal;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.sun.jbi.platform.PlatformContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import net.openesb.standalone.Lifecycle;
import net.openesb.standalone.core.CoreModule;
import net.openesb.standalone.env.Environment;
import net.openesb.standalone.env.EnvironmentModule;
import net.openesb.standalone.framework.FrameworkModule;
import net.openesb.standalone.framework.FrameworkService;
import net.openesb.standalone.http.HttpModule;
import net.openesb.standalone.http.HttpServer;
import net.openesb.standalone.inject.ModulesBuilder;
import net.openesb.standalone.jmx.JMXService;
import net.openesb.standalone.jta.TransactionManagerService;
import net.openesb.standalone.jta.TransactionModule;
import net.openesb.standalone.naming.NamingModule;
import net.openesb.standalone.node.Node;
import net.openesb.standalone.node.internal.InstanceSettingsPreparer;
import net.openesb.standalone.node.internal.NodeModule;
import net.openesb.standalone.plugins.PluginsModule;
import net.openesb.standalone.plugins.PluginsService;
import net.openesb.standalone.settings.Settings;
import net.openesb.standalone.settings.SettingsModule;
import net.openesb.standalone.utils.I18NBundle;
import net.openesb.standalone.utils.ManifestUtils;

public class InstanceNode
implements Node {
    private static final Logger LOG = Logger.getLogger(InstanceNode.class.getPackage().getName());
    private static final String INSTANCE_NAME = "instance.name";
    private final String nodeName;
    private final Injector injector;
    private final Environment environment;
    private JMXService jMXService;
    private TransactionManagerService tmService;
    private final PluginsService pluginsService;

    public InstanceNode() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("CONTAINER_INIT_INSTANCE"));
        }
        Settings settings = InstanceSettingsPreparer.prepareSettings();
        this.environment = new Environment(settings);
        this.prepareSystemProperties();
        this.pluginsService = new PluginsService(settings, this.environment);
        ModulesBuilder modules = new ModulesBuilder();
        modules.add((Module)new SettingsModule(settings));
        modules.add((Module)new PluginsModule(settings, this.pluginsService));
        modules.add((Module)new CoreModule());
        modules.add((Module)new FrameworkModule());
        modules.add((Module)new NamingModule());
        modules.add((Module)new TransactionModule());
        modules.add((Module)new HttpModule());
        modules.add((Module)new NodeModule(this));
        modules.add((Module)new EnvironmentModule(this.environment));
        this.injector = modules.createInjector();
        this.nodeName = settings.get(INSTANCE_NAME, "server");
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("CONTAINER_INIT_INSTANCE_DONE"), this.nodeName);
        }
    }

    @Override
    public void start() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("CONTAINER_START_INSTANCE"), this.nodeName);
        }
        long startTime = System.currentTimeMillis();
        for (Class<? extends Lifecycle> plugin : this.pluginsService.services()) {
            ((Lifecycle)this.injector.getInstance(plugin)).start();
        }
        this.jMXService = (JMXService)this.injector.getInstance(JMXService.class);
        this.jMXService.start();
        this.tmService = (TransactionManagerService)this.injector.getInstance(TransactionManagerService.class);
        this.tmService.start();
        ((FrameworkService)this.injector.getInstance(FrameworkService.class)).start();
        ((HttpServer)this.injector.getInstance(HttpServer.class)).start();
        PlatformContext platformContext = (PlatformContext)this.injector.getInstance(PlatformContext.class);
        try {
            ObjectName fwMBeanName = new ObjectName("net.open-esb.standalone", "instance", platformContext.getInstanceName());
            MBeanServer mbs = platformContext.getMBeanServer();
            if (mbs.isRegistered(fwMBeanName)) {
                if (mbs.getAttribute(fwMBeanName, "Loaded").equals(Boolean.TRUE)) {
                    throw new IllegalStateException("JBI framework instance " + platformContext.getInstanceName() + " has already been loaded");
                }
                mbs.unregisterMBean(fwMBeanName);
            }
            StandardMBean mbean = new StandardMBean(this, Node.class);
            mbs.registerMBean(mbean, fwMBeanName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("CONTAINER_START_INSTANCE_DONE"), new Object[]{this.nodeName, ManifestUtils.getVersion(), endTime - startTime});
        }
    }

    @Override
    public void stop() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("CONTAINER_STOP_INSTANCE"), this.nodeName);
        }
        ((HttpServer)this.injector.getInstance(HttpServer.class)).stop();
        ((FrameworkService)this.injector.getInstance(FrameworkService.class)).stop();
        this.tmService.stop();
        this.jMXService.stop();
        for (Class<? extends Lifecycle> plugin : this.pluginsService.services()) {
            ((Lifecycle)this.injector.getInstance(plugin)).stop();
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, I18NBundle.getBundle().getMessage("CONTAINER_STOP_INSTANCE_DONE"), this.nodeName);
        }
    }

    @Override
    public String name() {
        return this.nodeName;
    }

    private void prepareSystemProperties() {
        if (System.getProperty("java.vendor").equals("IBM Corporation")) {
            System.setProperty("com.sun.xml.ws.monitoring.endpoint", "false");
            System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl");
            System.setProperty("javax.xml.soap.SOAPFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl");
            System.setProperty("javax.xml.soap.SOAPConnectionFactory", "com.sun.xml.internal.messaging.saaj.client.p2p.HttpSOAPConnectionFactory");
            System.setProperty("javax.xml.soap.MetaFactory", "com.sun.xml.internal.messaging.saaj.soap.SAAJMetaFactoryImpl");
        }
    }
}

