/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.nav2.webapps.accessctl;

import com.meterware.httpunit.Button;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import net.ontopia.topicmaps.webed.AbstractWebBasedTestCase;
import org.junit.Test;
import org.xml.sax.SAXException;

public class AccessctlTest
extends AbstractWebBasedTestCase {
    private WebResponse resp;

    public AccessctlTest(String aName) {
        super(aName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.webedTestApplication = System.getProperty("net.ontopia.webed.test.testApplicationPath", "/accessctl");
        this.webedTestLocation = System.getProperty("net.ontopia.webed.test.testServerLocation", "http://127.0.0.1:8080") + this.webedTestApplication;
    }

    @Test
    public void testLogin() throws Exception {
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.login();
        this.clickOn("Logout");
    }

    @Test
    public void testPasswordChange() throws Exception {
        this.getPage("index.jsp");
        int linkCount = this.resp.getLinks().length;
        AccessctlTest.assertEquals((String)"number of links", (int)6, (int)linkCount);
        this.clickOn("Click here to change your password.");
        this.login();
        this.checkField("enterpw", "");
        this.changeField("enterpw", "pencil");
        this.clickButton("submit");
        this.clickOn("Click here to change your password.");
        this.checkField("enterpw", "");
        this.changeField("enterpw", "pen");
        this.clickButton("cancel");
        this.getPage("index.jsp");
        this.clickOn("Click here to change your password.");
        this.checkField("enterpw", "");
        this.changeField("enterpw", "secret");
        this.clickButton("submit");
    }

    @Test
    public void testMain() throws Exception {
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.login();
        WebTable table = this.resp.getTables()[0];
        AccessctlTest.assertEquals((String)"rows", (int)5, (int)table.getRowCount());
        AccessctlTest.assertEquals((String)"columns", (int)3, (int)table.getColumnCount());
        WebLink link = table.getTableCell(0, 0).getLinks()[0];
        AccessctlTest.assertNotNull((Object)link);
        link.click();
        this.resp = this.wc.getCurrentPage();
        table = this.resp.getTables()[0];
        AccessctlTest.assertEquals((String)"rows", (int)10, (int)table.getRowCount());
        AccessctlTest.assertEquals((String)"columns", (int)3, (int)table.getColumnCount());
    }

    @Test
    public void testUserGroupChange() throws Exception {
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.login();
        this.clickOn("Maintain User Groups");
        this.clickButton("create");
        this.changeField("enterName", "Clay Users");
        this.clickButton("save");
        this.clickOn("Clay Users");
        this.changeField("enterName", "Platinum Users");
        this.clickButton("save");
        this.clickOn("Platinum Users");
        this.assertUnchecked("Private Administrative Users");
        this.setCheckbox(this.rowOf("Private Administrative Users"), true);
        this.assertChecked("Private Administrative Users");
        this.clickButton("save");
        this.clickOn("Platinum Users");
        this.assertChecked("Private Administrative Users");
        this.changeField("enterName", "Clay Users");
        this.clickButton("cancel");
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.clickOn("User Groups");
        this.clickButton(this.rowOfLink("Platinum Users"));
        this.clickButton("create");
        this.changeField("enterName", "New Users");
        this.clickButton("save");
        this.clickOn("New Users");
        this.checkField("enterName", "New Users");
        this.clickButton("cancel");
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.clickOn("User Groups");
        AccessctlTest.assertNotNull((Object)this.resp.getLinkWith("New Users"));
        this.clickButton(this.rowOfLink("New Users"));
        AccessctlTest.assertNull((Object)this.resp.getLinkWith("New Users"));
        this.clickButton("create");
        this.changeField("enterName", "Dummygroup");
        this.clickButton("cancel");
        AccessctlTest.assertNull((Object)this.resp.getLinkWith("Dummygroup"));
    }

    @Test
    public void testPrivilegeCheckBox() throws Exception {
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.login();
        this.clickButton("createNewPrivilege");
        this.changeField("enterName", "Live in Oslo");
        this.changeField("enterSI", "http://Live.in.Oslo");
        this.clickButton("save");
        this.clickOn("User Groups");
        this.clickButton("create");
        this.changeField("enterName", "Osloensere");
        this.assertUnchecked("Live in Oslo");
        this.setCheckbox(this.rowOf("Live in Oslo"), true);
        this.assertChecked("Live in Oslo");
        this.clickButton("save");
        this.clickOn("Osloensere");
        this.assertChecked("Live in Oslo");
        this.clickButton("cancel");
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.clickOn("Privileges");
        this.clickButton(this.rowOfLink("Live in Oslo"));
        this.clickOn("User Groups");
        this.clickButton(this.rowOfLink("Osloensere"));
    }

    @Test
    public void testUserChange() throws Exception {
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.login();
        this.clickOn("Maintain Users");
        this.clickButton("create");
        this.changeField("enterName", "Mickey Mouse");
        this.changeField("enterUsername", "mickey mouse");
        this.changeField("enterPassword", "mikke mus");
        this.clickButton("save");
        this.clickOn("Mickey Mouse");
        this.checkField("enterUsername", "mickey mouse");
        this.checkField("enterPassword", "");
        this.changeField("enterName", "Mickenney Mouse");
        this.changeField("enterUsername", "mickenney mouse");
        this.changeField("enterPassword", "mikkel mus");
        this.clickButton("save");
        this.clickOn("Mickenney Mouse");
        this.changeField("enterName", "Mickey Mouse");
        this.clickButton("cancel");
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.clickOn("Users");
        this.clickOn("Mickenney Mouse");
        this.clickButton("cancel");
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.clickOn("Users");
        this.clickButton(this.rowOfLink("Mickenney Mouse"));
        this.clickButton("create");
        this.checkField("enterName", "New User");
        this.checkField("enterUsername", "New User");
        this.checkField("enterPassword", "");
        this.changeField("enterName", "Mr. Nelson");
        this.changeField("enterPassword", "foo");
        this.clickButton("save");
        this.clickOn("Mr. Nelson");
        this.checkField("enterName", "Mr. Nelson");
        this.checkField("enterPassword", "");
        this.clickButton("cancel");
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.clickOn("Users");
        AccessctlTest.assertNotNull((Object)this.resp.getLinkWith("Mr. Nelson"));
        this.clickButton(this.rowOfLink("Mr. Nelson"));
        AccessctlTest.assertNull((Object)this.resp.getLinkWith("Mr. Nelson"));
        this.clickButton("create");
        this.changeField("enterName", "Dummy");
        this.changeField("enterPassword", "dum");
        this.clickButton("cancel");
        AccessctlTest.assertNull((Object)this.resp.getLinkWith("Dummy"));
    }

    @Test
    public void testPrivilegeChange() throws Exception {
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.login();
        this.clickOn("Maintain Privileges");
        this.clickButton("create");
        this.changeField("enterName", "To be happy");
        this.changeField("enterSI", "http://to.be.happy");
        this.clickButton("save");
        this.clickOn("To be happy");
        this.changeField("enterName", "To be cheerful");
        this.clickButton("save");
        this.clickOn("To be cheerful");
        this.changeField("enterName", "To be happy");
        this.clickButton("cancel");
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.clickOn("Privileges");
        this.clickButton(this.rowOfLink("To be cheerful"));
        this.clickButton("create");
        this.changeField("enterName", "To get lunch");
        this.changeField("enterSI", "http://togetlunch.no");
        this.clickButton("save");
        this.clickOn("To get lunch");
        this.checkField("enterName", "To get lunch");
        this.changeField("enterSI", "http://togetlunch.no");
        this.clickButton("cancel");
        this.getPage("index.jsp");
        this.clickOn("Click here to enter the Administrator Main Page.");
        this.clickOn("Privileges");
        this.clickButton(this.rowOfLink("To get lunch"));
        this.clickButton("create");
        this.changeField("enterName", "Dummylege");
        this.changeField("enterSI", "http://dummylege.no");
        this.clickButton("cancel");
        AccessctlTest.assertNull((Object)this.resp.getLinkWith("Dummylege"));
        this.clickOn("Logout");
    }

    protected void login() throws Exception {
        AccessctlTest.assertNotNull((Object)this.resp.getElementWithID("name"));
        AccessctlTest.assertNotNull((Object)this.resp.getElementWithID("passw"));
        this.changeField("name", "johndoe");
        this.changeField("passw", "secret");
        this.clickButton("submit");
    }

    protected void getPage(String relativePath) throws SAXException, IOException {
        this.resp = this.wc.getResponse(this.webedTestLocation + "/" + relativePath);
    }

    protected void clickOn(String linkText) throws SAXException, IOException {
        WebLink link = this.resp.getLinkWith(linkText);
        AccessctlTest.assertNotNull((Object)link);
        link.click();
        this.resp = this.wc.getCurrentPage();
    }

    protected void clickButton(String buttonID) throws SAXException, IOException {
        WebForm[] forms = this.resp.getForms();
        AccessctlTest.assertTrue((forms.length > 0 ? 1 : 0) != 0);
        WebForm form = forms[0];
        Button button = form.getButtonWithID(buttonID);
        AccessctlTest.assertNotNull((Object)button);
        button.click();
        this.resp = this.wc.getCurrentPage();
    }

    protected void changeField(String fieldID, String newValue) throws SAXException {
        WebForm[] forms = this.resp.getForms();
        WebForm form = forms[0];
        HTMLElement field = this.resp.getElementWithID(fieldID);
        AccessctlTest.assertNotNull((Object)field);
        form.setParameter(field.getName(), newValue);
    }

    protected void checkField(String fieldID, String controlValue) throws SAXException {
        HTMLElement field = this.resp.getElementWithID(fieldID);
        AccessctlTest.assertNotNull((Object)field);
        WebForm[] forms = this.resp.getForms();
        AccessctlTest.assertTrue((String)"more than 0 forms", (forms.length > 0 ? 1 : 0) != 0);
        WebForm form0 = forms[0];
        String value = form0.getParameterValue(field.getName());
        AccessctlTest.assertEquals((String)fieldID, (String)controlValue, (String)value);
    }

    protected void assertChecked(String name, int row) throws SAXException {
        WebTable privilegeTable = this.resp.getTables()[0];
        AccessctlTest.assertNotNull((Object)privilegeTable);
        String assignName = privilegeTable.getTableCell(row, 0).getElementNames()[0];
        AccessctlTest.assertEquals((String)name, (String)"on", (String)this.resp.getForms()[0].getParameterValue(assignName));
    }

    protected void assertChecked(String name) throws SAXException {
        this.assertChecked(name, this.rowOf(name));
    }

    protected void assertUnchecked(String name, int row) throws SAXException {
        WebTable privilegeTable = this.resp.getTables()[0];
        AccessctlTest.assertNotNull((Object)privilegeTable);
        String assignName = privilegeTable.getTableCell(row, 0).getElementNames()[0];
        AccessctlTest.assertEquals((String)name, null, (String)this.resp.getForms()[0].getParameterValue(assignName));
    }

    protected void assertUnchecked(String name) throws SAXException {
        this.assertUnchecked(name, this.rowOf(name));
    }

    protected int rowOf(String text) throws SAXException {
        int row;
        WebTable table = this.resp.getTables()[0];
        AccessctlTest.assertNotNull((Object)table);
        for (row = 0; row < table.getRowCount() && !table.getTableCell(row, 1).asText().equals(text); ++row) {
        }
        AccessctlTest.assertTrue((String)("The text \"" + text + "\" was not found in any tablerow."), (row < table.getRowCount() ? 1 : 0) != 0);
        return row;
    }

    protected int rowOfLink(String text) throws SAXException {
        int row;
        WebTable table = this.resp.getTables()[0];
        AccessctlTest.assertNotNull((Object)table);
        for (row = 0; row < table.getRowCount() && table.getTableCell(row, 0).getLinkWith(text) == null; ++row) {
        }
        AccessctlTest.assertTrue((String)("A link with the text \"" + text + "\" was not found in any" + " tablerow."), (row < table.getRowCount() ? 1 : 0) != 0);
        return row;
    }

    protected void clickButton(int row) throws SAXException, IOException {
        WebForm[] forms = this.resp.getForms();
        AccessctlTest.assertTrue((forms.length > 0 ? 1 : 0) != 0);
        WebForm form = forms[0];
        this.clickButton(form, row);
    }

    protected WebForm getForm(String formID) throws SAXException {
        WebForm form = this.resp.getFormWithID(formID);
        AccessctlTest.assertNotNull((Object)form);
        return form;
    }

    protected void clickButton(WebForm form, int row) throws SAXException, IOException {
        Button[] buttons = form.getButtons();
        AccessctlTest.assertTrue((buttons.length > row + 1 ? 1 : 0) != 0);
        Button button = buttons[row + 1];
        button.click();
        this.resp = this.wc.getCurrentPage();
    }

    protected void setCheckbox(int row, boolean value) throws SAXException {
        WebTable[] tables = this.resp.getTables();
        AccessctlTest.assertTrue((tables.length > 0 ? 1 : 0) != 0);
        WebTable table = tables[0];
        AccessctlTest.assertNotNull((Object)table);
        String assignName = table.getTableCell(row, 0).getElementNames()[0];
        this.resp.getForms()[0].setCheckbox(assignName, value);
    }
}

