/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.nav2.webapps.accessctl;

import com.meterware.httpunit.Button;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.Random;
import net.ontopia.topicmaps.webed.AbstractWebBasedTestCase;
import net.ontopia.utils.StringUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AccessctlRandomizedTest
extends AbstractWebBasedTestCase {
    private static Logger log = LoggerFactory.getLogger((String)AccessctlRandomizedTest.class.getName());
    protected int visitCount = 0;
    public static int VISIT_LIMIT = 100000;
    protected int privileges;
    protected int users;
    protected int userGroups;
    protected Random random = new Random();
    private WebResponse resp;

    public AccessctlRandomizedTest(String aName) {
        super(aName);
        log.debug("Started");
        this.privileges = 0;
        this.users = 0;
        this.userGroups = 0;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.webedTestApplication = System.getProperty("net.ontopia.webed.test.testApplicationPath", "/accessctl");
        this.webedTestLocation = System.getProperty("net.ontopia.webed.test.testServerLocation", "http://127.0.0.1:8080") + this.webedTestApplication;
    }

    @Test
    public void testAtRandom() throws IOException, SAXException {
        this.getPage("index.jsp");
        while (this.visitCount <= VISIT_LIMIT) {
            this.visitCurrentPage();
        }
        log.debug("Finished");
    }

    public void visitCurrentPage() throws IOException, SAXException {
        ++this.visitCount;
        String pageName = this.resp.getURL().getPath().toString();
        pageName = pageName.substring(pageName.lastIndexOf(47) + 1);
        log.debug("Visiting " + pageName);
        if (pageName.equals("index.jsp")) {
            this.visitIndex();
        } else if (pageName.equals("main.jsp")) {
            this.visitMain();
        } else if (pageName.equals("password.jsp")) {
            this.visitPassword();
        } else if (pageName.equals("privilege.jsp")) {
            this.visitPrivilege();
        } else if (pageName.equals("privileges.jsp")) {
            this.visitPrivileges();
        } else if (pageName.equals("user.jsp")) {
            this.visitUser();
        } else if (pageName.equals("users.jsp")) {
            this.visitUsers();
        } else if (pageName.equals("userGroup.jsp")) {
            this.visitUserGroup();
        } else if (pageName.equals("userGroups.jsp")) {
            this.visitUserGroups();
        } else {
            log.debug("Don't recognize " + pageName);
        }
    }

    public void visitIndex() throws IOException, SAXException {
        if (this.random.nextBoolean()) {
            this.clickLinkNumber(0);
        } else {
            this.clickRandomLink();
        }
        this.login();
    }

    public void visitMain() throws IOException, SAXException {
        log.debug("Main - Links: " + this.resp.getLinks().length);
        int choice = this.random.nextInt(100);
        if (choice < 30) {
            this.clickButton("privilegeCreation", "createNewPrivilege");
        } else if (choice < 60) {
            this.clickButton("userCreation", "createNewUser");
        } else if (choice < 90) {
            this.clickButton("userGroupCreation", "createNewUserGroup");
        } else {
            this.clickRandomLinkOrButton();
        }
    }

    public void visitPassword() throws IOException, SAXException {
        this.clickRandomButton();
    }

    public void visitPrivilege() throws IOException, SAXException {
        this.changeField("enterName", StringUtils.makeRandomId((int)(2 + this.random.nextInt(10))));
        this.changeField("enterSI", StringUtils.makeRandomId((int)(2 + this.random.nextInt(4))) + "://" + StringUtils.makeRandomId((int)(2 + this.random.nextInt(15))));
        this.clickRandomButton();
    }

    public int getButtonCount() throws SAXException {
        WebForm[] forms = this.resp.getForms();
        AccessctlRandomizedTest.assertTrue((forms.length > 0 ? 1 : 0) != 0);
        WebForm form = forms[0];
        return form.getButtons().length;
    }

    public void visitPrivileges() throws IOException, SAXException {
        int choice;
        int buttonCount = this.getButtonCount();
        if (buttonCount > this.privileges) {
            log.debug("Privileges: : " + this.privileges);
            this.privileges = buttonCount;
        }
        if ((choice = this.random.nextInt(100)) < 95) {
            this.clickButton("create");
        } else {
            this.clickRandomLinkOrButton();
        }
    }

    public void visitUser() throws IOException, SAXException {
        if (this.random.nextBoolean()) {
            this.changeField("enterName", StringUtils.makeRandomId((int)(2 + this.random.nextInt(10))));
        }
        if (this.random.nextBoolean()) {
            this.changeField("enterUsername", StringUtils.makeRandomId((int)(2 + this.random.nextInt(10))));
        }
        if (this.random.nextBoolean()) {
            this.changeField("enterPassword", StringUtils.makeRandomId((int)(2 + this.random.nextInt(10))));
        }
        this.clickRandomButton();
    }

    public void visitUsers() throws IOException, SAXException {
        int choice;
        int buttonCount = this.getButtonCount();
        if (buttonCount > this.users) {
            log.debug("Users: : " + this.users);
            this.users = buttonCount;
        }
        if ((choice = this.random.nextInt(100)) < 95) {
            this.clickButton("create");
        } else {
            this.clickRandomLinkOrButton();
        }
    }

    public void visitUserGroup() throws IOException, SAXException {
        if (this.random.nextBoolean()) {
            this.changeField("enterName", StringUtils.makeRandomId((int)(2 + this.random.nextInt(10))));
        }
        this.clickRandomButton();
    }

    public void visitUserGroups() throws IOException, SAXException {
        int choice;
        int buttonCount = this.getButtonCount();
        if (buttonCount > this.userGroups) {
            log.debug("User Groups: : " + this.userGroups);
            this.userGroups = buttonCount;
        }
        if ((choice = this.random.nextInt(100)) < 95) {
            this.clickButton("create");
        } else {
            this.clickRandomLinkOrButton();
        }
    }

    public void clickRandomLinkOrButton() throws IOException, SAXException {
        if (this.random.nextBoolean()) {
            this.clickRandomLink();
        } else {
            this.clickRandomButton();
        }
    }

    public void clickRandomLink() throws IOException, SAXException {
        int choice;
        WebLink[] links = this.resp.getLinks();
        WebLink link = links[choice = this.random.nextInt(links.length)];
        if (link != null && !link.getURLString().startsWith("http://")) {
            log.debug("Clicking Link: " + link.asText());
            this.clickFiltered(link);
        }
    }

    public void clickFiltered(WebLink link) throws IOException, SAXException {
        String text = link.asText();
        if (!(text.equals("John Doe") || text.equals("Gold Users") || text.equals("Private Administrative Users"))) {
            log.debug("Clicing Link: " + text);
            link.click();
            this.resp = this.wc.getCurrentPage();
        }
    }

    public void clickLinkNumber(int index) throws IOException, SAXException {
        log.debug("Clicking link number: " + index);
        WebLink[] links = this.resp.getLinks();
        log.debug("Links: " + links.length);
        if (index >= links.length) {
            index = links.length - 1;
        }
        WebLink link = links[index];
        log.debug("Index: " + index + " text: " + link.getName());
        if (link != null && !link.getURLString().startsWith("http://")) {
            this.clickFiltered(link);
        }
    }

    public void clickRandomButton() throws IOException, SAXException {
        WebForm[] forms = this.resp.getForms();
        WebForm form = forms[this.random.nextInt(forms.length)];
        Button[] buttons = form.getButtons();
        Button button = buttons[this.random.nextInt(buttons.length)];
        button.click();
        log.debug("Clicked Button: " + button.getID());
        this.resp = this.wc.getCurrentPage();
    }

    protected void changeField(String fieldID, String newValue) throws SAXException {
        HTMLElement field = this.resp.getElementWithID(fieldID);
        AccessctlRandomizedTest.assertNotNull((Object)field);
        WebForm[] forms = this.resp.getForms();
        AccessctlRandomizedTest.assertTrue((forms.length > 0 ? 1 : 0) != 0);
        WebForm form = forms[0];
        form.setParameter(field.getName(), newValue);
        log.debug("Changed Field: fieldID=" + fieldID + " newValue=" + newValue);
    }

    protected void clickOn(String linkText) throws SAXException, IOException {
        WebLink link = this.resp.getLinkWith(linkText);
        AccessctlRandomizedTest.assertNotNull((Object)link);
        this.clickFiltered(link);
    }

    protected void clickButton(String buttonID) throws SAXException, IOException {
        log.debug("Clicking Button: " + buttonID);
        WebForm[] forms = this.resp.getForms();
        AccessctlRandomizedTest.assertTrue((forms.length > 0 ? 1 : 0) != 0);
        WebForm form = forms[0];
        Button button = form.getButtonWithID(buttonID);
        AccessctlRandomizedTest.assertNotNull((Object)button);
        button.click();
        this.resp = this.wc.getCurrentPage();
    }

    protected void clickButton(String formID, String buttonID) throws SAXException, IOException {
        log.debug("Clicking Button: " + buttonID + " formID=" + formID);
        WebForm form = this.resp.getFormWithID(formID);
        AccessctlRandomizedTest.assertNotNull((Object)form);
        Button button = form.getButtonWithID(buttonID);
        AccessctlRandomizedTest.assertNotNull((Object)button);
        button.click();
        this.resp = this.wc.getCurrentPage();
    }

    protected void getPage(String relativePath) throws SAXException, IOException {
        this.resp = this.wc.getResponse(this.webedTestLocation + "/" + relativePath);
    }

    protected void login() throws IOException, SAXException {
        if (this.resp.getElementWithID("name") != null && this.resp.getElementWithID("passw") != null) {
            this.changeField("name", "johndoe");
            this.changeField("passw", "secret");
            this.clickButton("submit");
        }
    }
}

