/*
 * Decompiled with CFR 0.152.
 */
package net.onedaybeard.bitvector;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.onedaybeard.bitvector.BitVectorIt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0006\u0010\u0016\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0002J\u0011\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0002J\u0013\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0002J\u001d\u0010 \u001a\u00020\u00102\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\"H\u0086\bJ\u0011\u0010#\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0002H\u0086\u0002J\b\u0010$\u001a\u00020\u0002H\u0016J\u000e\u0010%\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0000J\t\u0010&\u001a\u00020'H\u0096\u0002J\u0006\u0010(\u001a\u00020\u0002J\u000e\u0010)\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0002J\u0019\u0010*\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0007H\u0086\u0002J\b\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0002J\u000e\u0010/\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0002J\u000e\u00100\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0002J\u0016\u00100\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0007J\u000e\u00101\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00062"}, d2={"Lnet/onedaybeard/bitvector/BitVector;", "", "", "()V", "copyFrom", "(Lnet/onedaybeard/bitvector/BitVector;)V", "isEmpty", "", "()Z", "words", "", "getWords", "()[I", "setWords", "([I)V", "and", "", "other", "andNot", "cardinality", "checkCapacity", "wordIndex", "clear", "index", "contains", "copy", "ensureCapacity", "bits", "equals", "obj", "", "flip", "forEachBit", "f", "Lkotlin/Function1;", "get", "hashCode", "intersects", "iterator", "Lkotlin/collections/IntIterator;", "length", "or", "set", "value", "toString", "", "unsafeClear", "unsafeGet", "unsafeSet", "xor", "bitvector-jvm"})
public final class BitVector
implements Iterable<Integer>,
KMappedMarker {
    @NotNull
    private int[] words;

    @NotNull
    public final int[] getWords() {
        return this.words;
    }

    public final void setWords(@NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
        this.words = nArray;
    }

    @NotNull
    public final BitVector copy() {
        return new BitVector(this);
    }

    public final boolean get(int index) {
        int $receiver$iv = index;
        int word = $receiver$iv >>> 5;
        return word < this.words.length && (this.words[word] & 1 << index) != 0;
    }

    public final void set(int index) {
        int $receiver$iv = index;
        int word = $receiver$iv >>> 5;
        this.checkCapacity(word);
        this.words[word] = this.words[word] | 1 << index;
    }

    public final void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean unsafeGet(int index) {
        void $receiver$iv;
        int n = index;
        int[] nArray = this.words;
        void var5_4 = $receiver$iv >>> 5;
        return (nArray[var5_4] & 1 << index) != 0;
    }

    public final void unsafeSet(int index) {
        int $receiver$iv = index;
        int word = $receiver$iv >>> 5;
        this.words[word] = this.words[word] | 1 << index;
    }

    public final void unsafeSet(int index, boolean value) {
        if (value) {
            this.unsafeSet(index);
        } else {
            this.unsafeClear(index);
        }
    }

    public final void flip(int index) {
        int $receiver$iv = index;
        int word = $receiver$iv >>> 5;
        this.checkCapacity(word);
        this.words[word] = this.words[word] ^ 1 << index;
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureCapacity(int bits) {
        void $receiver$iv;
        int n = bits;
        BitVector bitVector = this;
        void var5_4 = $receiver$iv >>> 5;
        bitVector.checkCapacity((int)var5_4);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCapacity(int wordIndex) {
        if (wordIndex >= this.words.length) {
            int[] nArray = new int[wordIndex + 1];
            BitVector bitVector = this;
            int[] a = nArray;
            int[] $receiver$iv = this.words;
            int index$iv = 0;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                void bits;
                int item$iv = $receiver$iv[i];
                int n = index$iv++;
                int n2 = item$iv;
                int idx = n;
                a[idx] = bits;
            }
            int[] nArray2 = nArray;
            bitVector.words = nArray2;
        }
    }

    public final void clear(int index) {
        int $receiver$iv = index;
        int word = $receiver$iv >>> 5;
        if (word >= this.words.length) {
            return;
        }
        this.words[word] = this.words[word] & ~(1 << index);
    }

    public final void unsafeClear(int index) {
        int $receiver$iv = index;
        int word = $receiver$iv >>> 5;
        this.words[word] = this.words[word] & ~(1 << index);
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        int n = 0;
        int n2 = this.words.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                this.words[i] = 0;
                if (i == n2) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int length() {
        int[] bits = this.words;
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((int[])bits)));
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void word;
                int bitsAtWord;
                if ((bitsAtWord = bits[word]) != 0) {
                    void $receiver$iv = word;
                    void var8_7 = ($receiver$iv << 5) + 32;
                    int n6 = Integer.numberOfLeadingZeros(bitsAtWord);
                    return (int)(var8_7 - n6);
                }
                if (word == n2) break;
                n = word + n3;
            }
        }
        return 0;
    }

    public final boolean isEmpty() {
        boolean bl;
        block1: {
            int[] $receiver$iv = this.words;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                int element$iv = $receiver$iv[i];
                int it = element$iv;
                if (it == 0) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public final void and(@NotNull BitVector other) {
        BitVector bitVector;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int n = this.words.length;
        int n2 = other.words.length;
        int commonWords = Math.min(n, n2);
        BitVector $receiver = bitVector = this;
        for (int i = 0; commonWords > i; ++i) {
            $receiver.words[i] = $receiver.words[i] & other.words[i];
        }
        if (this.words.length > commonWords) {
            int s = this.words.length;
            for (int i = commonWords; s > i; ++i) {
                this.words[i] = 0;
            }
        }
    }

    public final void andNot(@NotNull BitVector other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int n = this.words.length;
        int n2 = other.words.length;
        int commonWords = Math.min(n, n2);
        for (int i = 0; commonWords > i; ++i) {
            this.words[i] = this.words[i] & ~other.words[i];
        }
    }

    public final void or(@NotNull BitVector other) {
        BitVector bitVector;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int n = this.words.length;
        int n2 = other.words.length;
        int commonWords = Math.min(n, n2);
        BitVector $receiver = bitVector = this;
        for (int i = 0; commonWords > i; ++i) {
            $receiver.words[i] = $receiver.words[i] | other.words[i];
        }
        if (commonWords < other.words.length) {
            this.checkCapacity(other.words.length);
            int s = other.words.length;
            for (int i = commonWords; s > i; ++i) {
                this.words[i] = other.words[i];
            }
        }
    }

    public final void xor(@NotNull BitVector other) {
        BitVector bitVector;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int n = this.words.length;
        int n2 = other.words.length;
        int commonWords = Math.min(n, n2);
        BitVector $receiver = bitVector = this;
        for (int i = 0; commonWords > i; ++i) {
            $receiver.words[i] = $receiver.words[i] ^ other.words[i];
        }
        if (commonWords < other.words.length) {
            this.checkCapacity(other.words.length);
            int s = other.words.length;
            for (int i = commonWords; s > i; ++i) {
                this.words[i] = other.words[i];
            }
        }
    }

    public final boolean intersects(@NotNull BitVector other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int[] bits = this.words;
        int[] otherBits = other.words;
        int n = bits.length;
        int n2 = otherBits.length;
        int s = Math.min(n, n2);
        for (int i = 0; s > i; ++i) {
            if ((bits[i] & otherBits[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public final boolean contains(@NotNull BitVector other) {
        int i;
        int bitsLength;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int[] bits = this.words;
        int[] otherBits = other.words;
        int otherBitsLength = otherBits.length;
        int n = bitsLength = bits.length;
        int n2 = otherBitsLength - 1;
        if (n <= n2) {
            while (true) {
                if (otherBits[i] != 0) {
                    return false;
                }
                if (i == n2) break;
                ++i;
            }
        }
        int s = Math.min(bitsLength, otherBitsLength);
        for (i = 0; s > i; ++i) {
            if ((bits[i] & otherBits[i]) == otherBits[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int cardinality() {
        int count = 0;
        int n = 0;
        int n2 = this.words.length - 1;
        if (n <= n2) {
            while (true) {
                void bits$iv;
                void i;
                int n3 = this.words[i];
                int n4 = count;
                int n5 = Integer.bitCount((int)bits$iv);
                count = n4 + n5;
                if (i == n2) break;
                ++i;
            }
        }
        return count;
    }

    @NotNull
    public IntIterator iterator() {
        return new BitVectorIt(this);
    }

    public int hashCode() {
        int $receiver$iv = this.length();
        int word = $receiver$iv >>> 5;
        int hash = 0;
        for (int i = 0; word >= i; ++i) {
            hash = 127 * hash + this.words[i];
        }
        return hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (Intrinsics.areEqual(this.getClass(), obj.getClass()) ^ true) {
            return false;
        }
        BitVector other = (BitVector)obj;
        int[] otherBits = other.words;
        int n = this.words.length;
        int n2 = otherBits.length;
        int commonWords = Math.min(n, n2);
        for (int i = 0; commonWords > i; ++i) {
            if (this.words[i] == otherBits[i]) continue;
            return false;
        }
        if (this.words.length == otherBits.length) {
            return true;
        }
        return this.length() == other.length();
    }

    @NotNull
    public String toString() {
        int cardinality = this.cardinality();
        int n = 128;
        int end = Math.min(n, cardinality);
        if (cardinality > 0) {
            String first = "BitVector[" + cardinality + ": {" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)this, (int)128), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String last = cardinality > end ? " ...}]" : "}]";
            return first + last;
        }
        return "BitVector[]";
    }

    /*
     * WARNING - void declaration
     */
    public final void forEachBit(@NotNull Function1<? super Integer, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        int[] w = this.getWords();
        int size = w.length;
        for (int index = 0; size > index; ++index) {
            int t;
            for (int bitset = w[index]; bitset != 0; bitset ^= t) {
                void bits$iv;
                t = bitset & -bitset;
                int n = t - 1;
                int n2 = index << 5;
                Function1<? super Integer, Unit> function1 = f;
                int n3 = Integer.bitCount((int)bits$iv);
                function1.invoke((Object)(n2 + n3));
            }
        }
    }

    public BitVector() {
        this.words = new int[1];
    }

    /*
     * WARNING - void declaration
     */
    public BitVector(@NotNull BitVector copyFrom) {
        Intrinsics.checkParameterIsNotNull((Object)copyFrom, (String)"copyFrom");
        this.words = new int[1];
        this.words = new int[copyFrom.words.length];
        int n = 0;
        int n2 = this.words.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                this.words[i] = copyFrom.words[i];
                if (i == n2) break;
                ++i;
            }
        }
    }
}

