/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.Entity;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.IntBag;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public class IntBagEntitySerializer
implements Json.Serializer<IntBag> {
    private final World world;
    private final Bag<Entity> translatedIds = new Bag();
    private int recursionLevel;

    public IntBagEntitySerializer(World world) {
        this.world = world;
        world.inject((Object)this);
    }

    public void write(Json json, IntBag entities, Class knownType) {
        ++this.recursionLevel;
        if (this.recursionLevel == 1) {
            json.writeObjectStart();
            int s = entities.size();
            for (int i = 0; s > i; ++i) {
                Entity e = this.world.getEntity(entities.get(i));
                json.writeValue(Integer.toString(e.getId()), (Object)e);
            }
            json.writeObjectEnd();
        } else {
            json.writeArrayStart();
            int s = entities.size();
            for (int i = 0; s > i; ++i) {
                json.writeValue((Object)entities.get(i));
            }
            json.writeArrayEnd();
        }
        --this.recursionLevel;
    }

    public IntBag read(Json json, JsonValue jsonData, Class type) {
        ++this.recursionLevel;
        IntBag bag = new IntBag();
        if (this.recursionLevel == 1) {
            JsonValue entityArray;
            JsonValue entity = entityArray = jsonData.child;
            while (entity != null) {
                Entity e = (Entity)json.readValue(Entity.class, entity.child);
                this.translatedIds.set(Integer.parseInt(entity.name), (Object)e);
                bag.add(e.getId());
                entity = entity.next;
            }
        } else {
            JsonValue child = jsonData.child;
            while (child != null) {
                bag.add(((Integer)json.readValue(Integer.class, child)).intValue());
                child = child.next;
            }
        }
        --this.recursionLevel;
        return bag;
    }

    public Bag<Entity> getTranslatedIds() {
        return this.translatedIds;
    }
}

