/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import com.artemis.Archetype;
import com.artemis.Component;
import com.artemis.Entity;
import com.artemis.EntityEdit;
import com.artemis.Manager;
import com.artemis.World;
import com.artemis.managers.GroupManager;
import com.artemis.managers.PlayerManager;
import com.artemis.managers.TagManager;
import com.artemis.managers.UuidEntityManager;
import com.artemis.utils.reflect.ClassReflection;
import java.util.UUID;

public class EntityBuilder {
    private final World world;
    private final EntityEdit edit;

    public EntityBuilder(World world) {
        this.world = world;
        this.edit = world.createEntity().edit();
    }

    public EntityBuilder(World world, Archetype archetype) {
        this.world = world;
        this.edit = world.createEntity(archetype).edit();
    }

    public EntityBuilder with(Component component) {
        this.edit.add(component);
        return this;
    }

    public EntityBuilder with(Component component1, Component component2) {
        this.edit.add(component1);
        this.edit.add(component2);
        return this;
    }

    public EntityBuilder with(Component component1, Component component2, Component component3) {
        this.edit.add(component1);
        this.edit.add(component2);
        this.edit.add(component3);
        return this;
    }

    public EntityBuilder with(Component component1, Component component2, Component component3, Component component4) {
        this.edit.add(component1);
        this.edit.add(component2);
        this.edit.add(component3);
        this.edit.add(component4);
        return this;
    }

    public EntityBuilder with(Component component1, Component component2, Component component3, Component component4, Component component5) {
        this.edit.add(component1);
        this.edit.add(component2);
        this.edit.add(component3);
        this.edit.add(component4);
        this.edit.add(component5);
        return this;
    }

    public EntityBuilder with(Component ... components) {
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            this.edit.add(components[i]);
        }
        return this;
    }

    public EntityBuilder with(Class<? extends Component> component) {
        this.edit.create(component);
        return this;
    }

    public EntityBuilder with(Class<? extends Component> component1, Class<? extends Component> component2) {
        this.edit.create(component1);
        this.edit.create(component2);
        return this;
    }

    public EntityBuilder with(Class<? extends Component> component1, Class<? extends Component> component2, Class<? extends Component> component3) {
        this.edit.create(component1);
        this.edit.create(component2);
        this.edit.create(component3);
        return this;
    }

    public EntityBuilder with(Class<? extends Component> component1, Class<? extends Component> component2, Class<? extends Component> component3, Class<? extends Component> component4) {
        this.edit.create(component1);
        this.edit.create(component2);
        this.edit.create(component3);
        this.edit.create(component4);
        return this;
    }

    public EntityBuilder with(Class<? extends Component> component1, Class<? extends Component> component2, Class<? extends Component> component3, Class<? extends Component> component4, Class<? extends Component> component5) {
        this.edit.create(component1);
        this.edit.create(component2);
        this.edit.create(component3);
        this.edit.create(component4);
        this.edit.create(component5);
        return this;
    }

    public EntityBuilder with(Class<? extends Component> ... components) {
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            this.edit.create(components[i]);
        }
        return this;
    }

    public EntityBuilder UUID(UUID uuid) {
        this.resolveManager(UuidEntityManager.class).setUuid(this.edit.getEntity(), uuid);
        return this;
    }

    public EntityBuilder player(String player) {
        this.resolveManager(PlayerManager.class).setPlayer(this.edit.getEntity(), player);
        return this;
    }

    public EntityBuilder tag(String tag) {
        this.resolveManager(TagManager.class).register(tag, this.edit.getEntity());
        return this;
    }

    public EntityBuilder group(String group) {
        this.resolveManager(GroupManager.class).add(this.edit.getEntity(), group);
        return this;
    }

    public EntityBuilder groups(String ... groups) {
        for (int i = 0; groups.length > i; ++i) {
            this.group(groups[i]);
        }
        return this;
    }

    public Entity build() {
        return this.edit.getEntity();
    }

    protected <T extends Manager> T resolveManager(Class<T> type) {
        T teamManager = this.world.getManager(type);
        if (teamManager == null) {
            throw new RuntimeException("Register " + ClassReflection.getSimpleName(type) + " with your artemis world.");
        }
        return teamManager;
    }
}

