/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.managers;

import com.artemis.Manager;
import com.artemis.utils.Bag;
import com.artemis.utils.ImmutableBag;
import java.util.HashMap;
import java.util.Map;

public class TeamManager
extends Manager {
    private final Map<String, Bag<String>> playersByTeam = new HashMap<String, Bag<String>>();
    private final Map<String, String> teamByPlayer = new HashMap<String, String>();

    @Override
    protected void initialize() {
    }

    public String getTeam(String player) {
        return this.teamByPlayer.get(player);
    }

    public void setTeam(String player, String team) {
        this.removeFromTeam(player);
        this.teamByPlayer.put(player, team);
        Bag<String> players = this.playersByTeam.get(team);
        if (players == null) {
            players = new Bag();
            this.playersByTeam.put(team, players);
        }
        players.add(player);
    }

    public ImmutableBag<String> getPlayers(String team) {
        return this.playersByTeam.get(team);
    }

    public void removeFromTeam(String player) {
        Bag<String> players;
        String team = this.teamByPlayer.remove(player);
        if (team != null && (players = this.playersByTeam.get(team)) != null) {
            players.remove(player);
        }
    }
}

