/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentType;
import com.artemis.Entity;
import com.artemis.World;
import com.artemis.annotations.EntityId;
import com.artemis.io.EntityReference;
import com.artemis.io.SaveFileFormat;
import com.artemis.utils.Bag;
import com.artemis.utils.ConverterUtil;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionException;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class ReferenceTracker {
    Bag<EntityReference> referenced = new Bag();
    private Set<Class<?>> referencingTypes = new HashSet();
    private Set<Field> referencingFields = new HashSet<Field>();
    private BitSet entityIds = new BitSet();
    private World world;

    ReferenceTracker(World world) {
        this.world = world;
    }

    void inspectTypes(World world) {
        this.clear();
        ComponentManager cm = world.getComponentManager();
        for (ComponentType ct : cm.getComponentTypes()) {
            this.inspectType(ct.getType());
        }
    }

    void inspectTypes(Collection<Class<? extends Component>> types) {
        this.clear();
        for (Class<? extends Component> component : types) {
            this.inspectType(component);
        }
    }

    private void clear() {
        this.referencingFields.clear();
        this.referencingTypes.clear();
        this.referenced.clear();
    }

    private void inspectType(Class<?> type) {
        Field[] fields = ClassReflection.getDeclaredFields(type);
        for (int i = 0; fields.length > i; ++i) {
            Field f = fields[i];
            if (!this.isReferencingEntity(f) || this.referencingFields.contains(type)) continue;
            this.referencingFields.add(f);
            this.referencingTypes.add(type);
            this.referenced.add(new EntityReference(type, f));
        }
    }

    void addEntityReferencingComponent(Component c) {
        Class<?> componentClass = c.getClass();
        if (!this.referencingTypes.contains(componentClass)) {
            return;
        }
        int s = this.referenced.size();
        for (int i = 0; s > i; ++i) {
            EntityReference ref = this.referenced.get(i);
            if (ref.componentType != componentClass) continue;
            ref.operations.add(c);
        }
    }

    void translate(Bag<Entity> translations) {
        for (EntityReference ref : this.referenced) {
            ref.translate(translations);
        }
        translations.clear();
    }

    EntityReference find(Class<?> componentType, String fieldName) {
        int s = this.referenced.size();
        for (int i = 0; s > i; ++i) {
            EntityReference ref = this.referenced.get(i);
            if (!ref.componentType.equals(componentType) || !ref.field.getName().equals(fieldName)) continue;
            return ref;
        }
        throw new RuntimeException(componentType.getSimpleName() + "." + fieldName);
    }

    private boolean isReferencingEntity(Field f) {
        boolean explicitEntityId = f.getDeclaredAnnotation(EntityId.class) != null;
        Class type = f.getType();
        return Entity.class == type || Bag.class == type || Integer.TYPE == type && explicitEntityId || IntBag.class == type && explicitEntityId;
    }

    void preWrite(SaveFileFormat save) {
        this.entityIds.clear();
        ConverterUtil.toBitSet(save.entities, this.entityIds);
        boolean foundNew = true;
        BitSet bs = this.entityIds;
        while (foundNew) {
            foundNew = false;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                for (Field f : this.referencingFields) {
                    foundNew |= this.findReferences(i, f, bs);
                }
                i = bs.nextSetBit(i + 1);
            }
        }
        ConverterUtil.toIntBag(this.entityIds, save.entities);
    }

    private boolean findReferences(int entityId, Field f, BitSet referencedIds) {
        Object c = this.world.getEntity(entityId).getComponent(f.getDeclaringClass());
        if (c == null) {
            return false;
        }
        Class type = f.getType();
        try {
            if (type.equals(Integer.TYPE)) {
                return this.updateReferenced((Integer)f.get(c), referencedIds);
            }
            if (type.equals(Entity.class)) {
                return this.updateReferenced((Entity)f.get(c), referencedIds);
            }
            if (type.equals(IntBag.class)) {
                return this.updateReferenced((IntBag)f.get(c), referencedIds);
            }
            if (type.equals(Bag.class)) {
                return this.updateReferenced((Bag)f.get(c), referencedIds);
            }
            throw new RuntimeException("unknown type: " + type);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean updateReferenced(Bag<Entity> entities, BitSet referencedIds) {
        boolean updated = false;
        for (int i = 0; i < entities.size(); ++i) {
            updated |= this.updateReferenced(entities.get(i), referencedIds);
        }
        return updated;
    }

    private boolean updateReferenced(IntBag ids, BitSet referencedIds) {
        boolean updated = false;
        for (int i = 0; i < ids.size(); ++i) {
            updated |= this.updateReferenced(ids.get(i), referencedIds);
        }
        return updated;
    }

    private boolean updateReferenced(Entity e, BitSet referencedIds) {
        return this.updateReferenced(e.id, referencedIds);
    }

    private boolean updateReferenced(int entityId, BitSet referencedIds) {
        if (!referencedIds.get(entityId)) {
            referencedIds.set(entityId);
            return true;
        }
        return false;
    }
}

