/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.injection;

import com.artemis.World;
import com.artemis.injection.CachedField;
import com.artemis.injection.ClassType;
import com.artemis.injection.FieldResolver;
import com.artemis.injection.InjectionCache;
import com.artemis.injection.UseInjectionCache;
import com.artemis.injection.WireType;
import com.artemis.utils.reflect.Field;
import java.util.Map;

public class WiredFieldResolver
implements FieldResolver,
UseInjectionCache {
    private InjectionCache cache;
    private Map<String, Object> pojos;

    public WiredFieldResolver(Map<String, Object> pojos) {
        this.pojos = pojos;
    }

    @Override
    public void initialize(World world) {
    }

    @Override
    public Object resolve(Class<?> fieldType, Field field) {
        ClassType injectionType = this.cache.getFieldClassType(fieldType);
        CachedField cachedField = this.cache.getCachedField(field);
        if (injectionType == ClassType.CUSTOM && cachedField.wireType == WireType.WIRE) {
            String key = cachedField.name;
            if ("".equals(key)) {
                key = field.getType().getName();
            }
            return this.pojos.get(key);
        }
        return null;
    }

    @Override
    public void setCache(InjectionCache cache) {
        this.cache = cache;
    }
}

