/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.injection;

import com.artemis.World;
import com.artemis.injection.ArtemisFieldResolver;
import com.artemis.injection.FieldResolver;
import com.artemis.injection.InjectionCache;
import com.artemis.injection.UseInjectionCache;
import com.artemis.injection.WiredFieldResolver;
import com.artemis.utils.Bag;
import com.artemis.utils.reflect.Field;
import java.util.Map;

public class FieldHandler {
    private InjectionCache cache;
    protected Bag<FieldResolver> fieldResolvers;

    public FieldHandler(InjectionCache cache, Bag<FieldResolver> fieldResolvers) {
        this.cache = cache;
        this.fieldResolvers = fieldResolvers;
    }

    public FieldHandler(InjectionCache cache) {
        this.fieldResolvers = new Bag();
        this.cache = cache;
        this.addFieldResolver(new ArtemisFieldResolver());
    }

    public FieldHandler(InjectionCache cache, Map<String, Object> injectables) {
        this(cache);
        this.addFieldResolver(new WiredFieldResolver(injectables));
    }

    public void initialize(World world) {
        int s = this.fieldResolvers.size();
        for (int i = 0; i < s; ++i) {
            FieldResolver fieldResolver = this.fieldResolvers.get(i);
            if (fieldResolver instanceof UseInjectionCache) {
                ((UseInjectionCache)((Object)fieldResolver)).setCache(this.cache);
            }
            fieldResolver.initialize(world);
        }
    }

    public Object resolve(Class<?> fieldType, Field field) {
        int s = this.fieldResolvers.size();
        for (int i = 0; i < s; ++i) {
            Object resolved = this.fieldResolvers.get(i).resolve(fieldType, field);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    public final void addFieldResolver(FieldResolver fieldResolver) {
        this.fieldResolvers.add(fieldResolver);
    }
}

