/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.injection;

import com.artemis.MundaneWireException;
import com.artemis.World;
import com.artemis.injection.CachedClass;
import com.artemis.injection.CachedField;
import com.artemis.injection.ClassType;
import com.artemis.injection.FieldHandler;
import com.artemis.injection.InjectionCache;
import com.artemis.injection.Injector;
import com.artemis.injection.WireType;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CachedInjector
implements Injector {
    private InjectionCache cache = new InjectionCache();
    private FieldHandler fieldHandler;

    @Override
    public Injector setFieldHandler(FieldHandler fieldHandler) {
        this.fieldHandler = fieldHandler;
        return this;
    }

    @Override
    public void initialize(World world, Map<String, Object> injectables) {
        if (this.fieldHandler == null) {
            this.fieldHandler = new FieldHandler(this.cache, injectables);
        }
        this.fieldHandler.initialize(world);
    }

    @Override
    public boolean isInjectable(Object target) {
        try {
            CachedClass cachedClass = this.cache.getCachedClass(target.getClass());
            return cachedClass.wireType == WireType.WIRE;
        }
        catch (ReflectionException e) {
            throw new MundaneWireException("Error while wiring", e);
        }
    }

    @Override
    public void inject(Object target) throws RuntimeException {
        try {
            Class<?> clazz = target.getClass();
            CachedClass cachedClass = this.cache.getCachedClass(clazz);
            if (cachedClass.wireType == WireType.WIRE) {
                this.injectValidFields(target, cachedClass);
            } else {
                this.injectAnnotatedFields(target, cachedClass);
            }
        }
        catch (ReflectionException e) {
            throw new MundaneWireException("Error while wiring", e);
        }
    }

    private void injectValidFields(Object target, CachedClass cachedClass) throws ReflectionException {
        Field[] declaredFields = this.getAllInjectableFields(cachedClass);
        int s = declaredFields.length;
        for (int i = 0; s > i; ++i) {
            this.injectField(target, declaredFields[i], cachedClass.failOnNull);
        }
    }

    private Field[] getAllInjectableFields(CachedClass cachedClass) {
        Field[] declaredFields = cachedClass.allFields;
        if (declaredFields == null) {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            Class<?> clazz = cachedClass.clazz;
            this.collectDeclaredInjectableFields(fieldList, clazz);
            while (cachedClass.injectInherited && (clazz = clazz.getSuperclass()) != Object.class) {
                this.collectDeclaredInjectableFields(fieldList, clazz);
            }
            declaredFields = fieldList.toArray(new Field[fieldList.size()]);
            cachedClass.allFields = declaredFields;
        }
        return declaredFields;
    }

    private void collectDeclaredInjectableFields(List<Field> fieldList, Class<?> clazz) {
        try {
            if (this.cache.getCachedClass(clazz).wireType != WireType.SKIPWIRE) {
                Field[] classFields = ClassReflection.getDeclaredFields(clazz);
                for (int i = 0; i < classFields.length; ++i) {
                    if (!this.isWireable(classFields[i])) continue;
                    fieldList.add(classFields[i]);
                }
            }
        }
        catch (ReflectionException e) {
            throw new MundaneWireException("Error while wiring", e);
        }
    }

    private boolean isWireable(Field field) {
        return this.cache.getCachedField((Field)field).wireType != WireType.SKIPWIRE;
    }

    private void injectAnnotatedFields(Object target, CachedClass cachedClass) throws ReflectionException {
        this.injectClass(target, cachedClass);
    }

    private void injectClass(Object target, CachedClass cachedClass) throws ReflectionException {
        Field[] declaredFields = this.getAllInjectableFields(cachedClass);
        int s = declaredFields.length;
        for (int i = 0; s > i; ++i) {
            Field field = declaredFields[i];
            CachedField cachedField = this.cache.getCachedField(field);
            if (cachedField.wireType == WireType.IGNORED) continue;
            this.injectField(target, field, cachedField.wireType == WireType.WIRE);
        }
    }

    private void injectField(Object target, Field field, boolean failOnNotInjected) throws ReflectionException {
        Class fieldType;
        try {
            fieldType = field.getType();
        }
        catch (RuntimeException ignore) {
            return;
        }
        Object resolve = this.fieldHandler.resolve(fieldType, field);
        if (resolve != null) {
            this.setField(target, field, resolve);
        }
        if (resolve == null && failOnNotInjected && this.cache.getFieldClassType(fieldType) != ClassType.CUSTOM) {
            throw this.onFailedInjection(fieldType.getSimpleName(), field);
        }
    }

    private void setField(Object target, Field field, Object fieldValue) throws ReflectionException {
        field.setAccessible(true);
        field.set(target, fieldValue);
    }

    private MundaneWireException onFailedInjection(String typeName, Field failedInjection) {
        String error = "Failed to inject " + failedInjection.getType().getName() + " into " + failedInjection.getDeclaringClass().getName() + ": " + typeName + " not registered with world.";
        return new MundaneWireException(error);
    }
}

