/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.AspectSubscriptionManager;
import com.artemis.BaseSystem;
import com.artemis.Manager;
import com.artemis.SystemInvocationStrategy;
import com.artemis.World;
import com.artemis.injection.Injector;
import com.artemis.utils.Bag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.ReflectionException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public final class WorldConfiguration {
    final Bag<Manager> managers = new Bag();
    final Bag<BaseSystem> systems = new Bag();
    protected int expectedEntityCount = 128;
    protected Map<String, Object> injectables = new HashMap<String, Object>();
    protected Injector injector;
    protected SystemInvocationStrategy invocationStrategy;

    public WorldConfiguration() {
        this.managers.add(null);
        this.managers.add(null);
        this.managers.add(null);
    }

    public int expectedEntityCount() {
        return this.expectedEntityCount;
    }

    public WorldConfiguration expectedEntityCount(int expectedEntityCount) {
        this.expectedEntityCount = expectedEntityCount;
        return this;
    }

    public WorldConfiguration setInjector(Injector injector) {
        if (injector == null) {
            throw new NullPointerException();
        }
        this.injector = injector;
        return this;
    }

    public WorldConfiguration setInvocationStrategy(SystemInvocationStrategy invocationStrategy) {
        if (invocationStrategy == null) {
            throw new NullPointerException();
        }
        this.invocationStrategy = invocationStrategy;
        return this;
    }

    @Deprecated
    public int maxRebuiltIndicesPerTick() {
        return -1;
    }

    @Deprecated
    public WorldConfiguration maxRebuiltIndicesPerTick(int maxRebuiltIndicesPerTick) {
        return this;
    }

    public WorldConfiguration register(Object o) {
        return this.register(o.getClass().getName(), o);
    }

    public WorldConfiguration register(String name, Object o) {
        this.injectables.put(name, o);
        return this;
    }

    public WorldConfiguration setSystem(Class<? extends BaseSystem> system) {
        return this.setSystem((BaseSystem)((Object)system), false);
    }

    public WorldConfiguration setSystem(Class<? extends BaseSystem> system, boolean passive) {
        try {
            return this.setSystem(ClassReflection.newInstance(system), passive);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends BaseSystem> WorldConfiguration setSystem(T system) {
        return this.setSystem(system, false);
    }

    public <T extends BaseSystem> WorldConfiguration setSystem(T system, boolean passive) {
        system.setPassive(passive);
        this.systems.add(system);
        return this;
    }

    public final <T extends Manager> WorldConfiguration setManager(Class<T> manager) {
        try {
            return this.setManager((Manager)ClassReflection.newInstance(manager));
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public final <T extends Manager> WorldConfiguration setManager(T manager) {
        this.managers.add(manager);
        return this;
    }

    void initialize(World world, Injector injector, AspectSubscriptionManager asm) {
        if (this.invocationStrategy != null) {
            world.setInvocationStrategy(this.invocationStrategy);
        }
        this.managers.set(0, world.getComponentManager());
        this.managers.set(1, world.getEntityManager());
        this.managers.set(2, asm);
        for (Manager manager : this.managers) {
            world.managers.put(manager.getClass(), manager);
            manager.setWorld(world);
        }
        for (BaseSystem system : this.systems) {
            world.systems.put(system.getClass(), system);
            system.setWorld(world);
        }
        injector.initialize(world, this.injectables);
        for (int i = 0; i < this.managers.size(); ++i) {
            Manager manager;
            manager = this.managers.get(i);
            injector.inject(manager);
            manager.initialize();
        }
        this.initializeSystems(injector);
        asm.processComponentIdentity(1, new BitSet());
    }

    private void initializeSystems(Injector injector) {
        int s = this.systems.size();
        for (int i = 0; i < s; ++i) {
            BaseSystem system = this.systems.get(i);
            injector.inject(system);
            system.initialize();
        }
    }
}

