/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ProcessorUtil {
    private static DeclaredType factoryInterface;
    private static TypeElement ObjectElement;
    private static Types types;
    private static Elements elements;

    ProcessorUtil() {
    }

    public static void init(ProcessingEnvironment env) {
        types = env.getTypeUtils();
        elements = env.getElementUtils();
        factoryInterface = types.getDeclaredType(elements.getTypeElement("com.artemis.EntityFactory"), types.getWildcardType(null, null));
        ObjectElement = (TypeElement)types.getDeclaredType(elements.getTypeElement("java.lang.Object"), new TypeMirror[0]).asElement();
    }

    public static List<ExecutableElement> componentMethods(TypeElement element) {
        ArrayList<? extends Element> allMembers = new ArrayList<Element>();
        allMembers.addAll(elements.getAllMembers(element));
        allMembers.removeAll(elements.getAllMembers(ObjectElement));
        allMembers.removeAll(elements.getAllMembers((TypeElement)factoryInterface.asElement()));
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (Element element2 : allMembers) {
            if (element2.getKind() != ElementKind.METHOD) continue;
            methods.add((ExecutableElement)element2);
        }
        return methods;
    }

    public static Set<TypeElement> parentInterfaces(TypeElement main) {
        HashSet<TypeElement> interfaces = new HashSet<TypeElement>();
        interfaces.add(main);
        ProcessorUtil.parentInterfaces(main.getInterfaces(), interfaces);
        return interfaces;
    }

    private static void parentInterfaces(List<? extends TypeMirror> interfaceMirrors, Set<TypeElement> target) {
        for (TypeMirror typeMirror : interfaceMirrors) {
            TypeElement found = (TypeElement)((DeclaredType)typeMirror).asElement();
            target.add(found);
            ProcessorUtil.parentInterfaces(found.getInterfaces(), target);
        }
    }

    public static boolean isString(TypeMirror mirror) {
        if (!(mirror instanceof DeclaredType)) {
            return false;
        }
        DeclaredType type = (DeclaredType)mirror;
        Element e = type.asElement();
        if (!(e instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)e;
        return typeElement.getQualifiedName().toString().equals("java.lang.String");
    }

    public static boolean isEnum(TypeMirror mirror) {
        if (!(mirror instanceof DeclaredType)) {
            return false;
        }
        DeclaredType type = (DeclaredType)mirror;
        return ElementKind.ENUM == type.asElement().getKind();
    }

    public static DeclaredType findFactory(TypeElement klazz) {
        for (TypeMirror typeMirror : klazz.getInterfaces()) {
            if (!types.isSubtype(typeMirror, factoryInterface)) continue;
            return (DeclaredType)typeMirror;
        }
        return null;
    }

    public static AnnotationMirror mirror(String annotation, Element element) {
        if (!annotation.startsWith("@")) {
            annotation = "@" + annotation;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.toString().startsWith(annotation)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationMirror mirror(Class<? extends Annotation> annotation, Element element) {
        return ProcessorUtil.mirror("@" + annotation.getName(), element);
    }

    public static boolean hasMirror(String annotation, Element element) {
        return ProcessorUtil.mirror(annotation, element) != null;
    }

    public static boolean hasMethod(TypeElement component, String setterMethod) {
        for (Element element : component.getEnclosedElements()) {
            if (!ProcessorUtil.nameMatches(element, setterMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMethod(TypeElement component, String setterMethod, List<? extends VariableElement> params) {
        for (Element element : component.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement method = (ExecutableElement)element;
            if (!ProcessorUtil.nameMatches(element, setterMethod) || !ProcessorUtil.typesEqual(params, method.getParameters())) continue;
            return true;
        }
        return false;
    }

    private static boolean typesEqual(List<? extends VariableElement> params, List<? extends VariableElement> params2) {
        if (params.size() != params2.size()) {
            return false;
        }
        for (int i = 0; params.size() > i; ++i) {
            if (params.get(i).asType().equals(params2.get(i).asType())) continue;
            return false;
        }
        return true;
    }

    private static boolean nameMatches(Element e, String setterMethod) {
        return e.getKind() == ElementKind.METHOD && e.getSimpleName().toString().equals(setterMethod);
    }
}

