/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.FactoryModel;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;

public class ModelFormatter {
    private final Configuration config = new Configuration();

    ModelFormatter() {
        this.config.setClassForTemplateLoading(this.getClass(), "");
        this.config.setIncompatibleImprovements(new Version(2, 3, 20));
        this.config.setDefaultEncoding("UTF-8");
        this.config.setLocale(Locale.US);
        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }

    CharSequence generate(FactoryModel model) throws IOException {
        Template template = this.config.getTemplate("class.ftl");
        StringWriter out = new StringWriter();
        try {
            HashMap<String, FactoryModel> data = new HashMap<String, FactoryModel>();
            data.put("model", model);
            template.process(data, out);
            return out.toString();
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
    }

    static {
        try {
            Logger.selectLoggerLibrary(1);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

