/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.ProcessorUtil;
import com.artemis.annotations.Bind;
import com.artemis.annotations.Sticky;
import com.artemis.annotations.UseSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class FactoryModel {
    private final Set<TypeElement> components = new HashSet<TypeElement>();
    private final List<FactoryMethod> methods;
    final TypeElement declaration;
    private final Map<String, TypeElement> autoResolvable;
    private final ProcessingEnvironment env;
    private Messager messager;
    boolean success = true;
    private static final List<String> IGNORED_METHODS = Arrays.asList("getClass", "wait", "notify", "notifyAll", "equals", "hashCode", "equals", "toString", "copy", "create", "tag", "group");

    FactoryModel(TypeElement declaration, ProcessingEnvironment env) {
        this.declaration = declaration;
        this.env = env;
        this.messager = env.getMessager();
        this.autoResolvable = new HashMap<String, TypeElement>();
        for (TypeElement parent : ProcessorUtil.parentInterfaces(declaration)) {
            this.autoResolvable.putAll(this.readGlobalCRefs(parent));
        }
        this.autoResolvable.putAll(this.readGlobalCRefs(declaration));
        this.methods = this.scanMethods(declaration);
        this.validate();
    }

    private void validate() {
        DeclaredType argument;
        TypeElement factoryType;
        DeclaredType factory = ProcessorUtil.findFactory(this.declaration);
        if (factory == null) {
            this.success = false;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Interface must extend com.artemis.EntityFactory", this.declaration);
            return;
        }
        if (factory.getTypeArguments().size() > 0 && !(factoryType = (TypeElement)(argument = (DeclaredType)factory.getTypeArguments().get(0)).asElement()).getQualifiedName().equals(this.declaration.getQualifiedName())) {
            this.success = false;
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Expected EntityFactory<%s>, but found EntityFactory<%s>", this.declaration.getSimpleName(), factoryType.getSimpleName()), this.declaration);
        }
        for (FactoryMethod method : this.methods) {
            this.success &= method.validate(this.messager);
        }
    }

    public List<FactoryMethod> getStickyMethods() {
        ArrayList<FactoryMethod> m = new ArrayList<FactoryMethod>();
        for (FactoryMethod fm : this.methods) {
            if (!fm.sticky || fm.setterMethod != null) continue;
            m.add(fm);
        }
        return m;
    }

    public List<FactoryMethod> getInstanceMethods() {
        ArrayList<FactoryMethod> m = new ArrayList<FactoryMethod>();
        for (FactoryMethod fm : this.methods) {
            if (fm.sticky || fm.setterMethod != null) continue;
            m.add(fm);
        }
        return m;
    }

    public List<FactoryMethod> getSetterMethods() {
        ArrayList<FactoryMethod> m = new ArrayList<FactoryMethod>();
        for (FactoryMethod fm : this.methods) {
            if (fm.sticky || fm.setterMethod == null) continue;
            m.add(fm);
        }
        return m;
    }

    public String getPackageName() {
        String pkg = this.declaration.getEnclosingElement().toString();
        if (pkg.startsWith("package ")) {
            pkg = pkg.substring("package ".length());
        }
        return pkg;
    }

    public String getFactoryName() {
        return this.declaration.getSimpleName().toString();
    }

    public List<String> getComponents(boolean qualifiedName) {
        ArrayList<String> components = new ArrayList<String>();
        for (TypeElement c : this.components) {
            components.add((qualifiedName ? c.getQualifiedName() : c.getSimpleName()).toString());
        }
        return components;
    }

    public Set<String> getMappedComponents() {
        HashSet<String> components = new HashSet<String>();
        for (FactoryMethod m : this.methods) {
            components.add(m.component.getSimpleName().toString());
        }
        return components;
    }

    public Set<String> getFields() {
        TreeSet<String> fields = new TreeSet<String>();
        for (FactoryMethod m : this.methods) {
            if (!m.sticky) {
                fields.add("private boolean " + m.getFlagName());
            }
            for (Param p : m.getParams()) {
                fields.add(String.format("private %s %s", p.type, p.field));
            }
        }
        return fields;
    }

    private List<FactoryMethod> scanMethods(TypeElement factory) {
        return this.factoryMethods(ProcessorUtil.componentMethods(factory));
    }

    private List<FactoryMethod> factoryMethods(List<ExecutableElement> allMembers) {
        ArrayList<FactoryMethod> methods = new ArrayList<FactoryMethod>();
        for (ExecutableElement e : allMembers) {
            String elementName = e.getSimpleName().toString();
            if (!IGNORED_METHODS.contains(elementName)) {
                FactoryMethod method = this.factoryMethod(e);
                if (method != null) {
                    methods.add(method);
                    continue;
                }
                this.success = false;
                continue;
            }
            if (FactoryModel.readCRef(e).isEmpty()) continue;
            String err = "Invalid method name for factory method";
            this.messager.printMessage(Diagnostic.Kind.ERROR, err, e);
            this.success = false;
        }
        return methods;
    }

    private FactoryMethod factoryMethod(ExecutableElement e) {
        String elementName = e.getSimpleName().toString();
        List<AnnotationValue> referenced = FactoryModel.readCRef(e);
        if (referenced.size() == 0) {
            if (this.autoResolvable.containsKey(elementName)) {
                return new FactoryMethod(e, this.autoResolvable.get(elementName));
            }
            String err = "Unable to match component for " + e.getSimpleName();
            this.messager.printMessage(Diagnostic.Kind.ERROR, err, e);
            return null;
        }
        if (referenced.size() == 1) {
            return this.bindMethod(e, (DeclaredType)referenced.get(0).getValue());
        }
        String err = "@Bind on methods limited to one component type, found " + referenced.size();
        this.messager.printMessage(Diagnostic.Kind.ERROR, err, e);
        return null;
    }

    private FactoryMethod bindMethod(ExecutableElement method, DeclaredType value) {
        TypeElement component = (TypeElement)value.asElement();
        this.components.add(component);
        String setterMethod = null;
        AnnotationMirror setterMirror = ProcessorUtil.mirror(UseSetter.class, (Element)method);
        if (setterMirror != null) {
            AnnotationValue setter = FactoryModel.readAnnotationField(setterMirror, "value");
            setterMethod = setter != null ? (String)setter.getValue() : method.getSimpleName().toString();
        }
        return new FactoryMethod(method, component, setterMethod);
    }

    private Map<String, TypeElement> readGlobalCRefs(TypeElement declaration) {
        HashMap<String, TypeElement> autoResolvable = new HashMap<String, TypeElement>();
        for (AnnotationValue value : FactoryModel.readCRef(declaration)) {
            TypeElement type = (TypeElement)((DeclaredType)value.getValue()).asElement();
            this.components.add(type);
            autoResolvable.put(FactoryModel.key(type), type);
        }
        return autoResolvable;
    }

    private static List<AnnotationValue> readCRef(Element element) {
        AnnotationMirror cref = ProcessorUtil.mirror(Bind.class, element);
        if (cref == null) {
            return Collections.emptyList();
        }
        AnnotationValue components = FactoryModel.readAnnotationField(cref, "value");
        return (List)components.getValue();
    }

    private static String key(TypeElement type) {
        String key = type.getSimpleName().toString();
        return key.toLowerCase().charAt(0) + key.substring(1);
    }

    static AnnotationValue readAnnotationField(AnnotationMirror annotation, String field) {
        for (ExecutableElement executableElement : annotation.getElementValues().keySet()) {
            if (!field.equals(executableElement.getSimpleName().toString())) continue;
            return annotation.getElementValues().get(executableElement);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FactoryModel:" + this.getPackageName() + this.declaration.getSimpleName() + "(\n");
        String delim = "";
        sb.append("\tarchetype=");
        for (TypeElement c : this.components) {
            sb.append(delim).append(c.getSimpleName());
            delim = ", ";
        }
        sb.append("\n");
        for (FactoryMethod m : this.methods) {
            sb.append('\t').append(m).append('\n');
        }
        sb.append(')');
        return sb.toString();
    }

    private static String camelCase(CharSequence s) {
        return Character.toLowerCase(s.charAt(0)) + s.toString().substring(1);
    }

    public static class Param {
        private final String field;
        private final String param;
        private final String type;

        Param(TypeElement component, VariableElement param) {
            this.param = FactoryModel.camelCase(param.getSimpleName());
            this.field = String.format("_%s_%s", FactoryModel.camelCase(component.getSimpleName()), this.param);
            this.type = param.asType().toString();
        }

        public String getType() {
            return this.type;
        }

        public String getField() {
            return this.field;
        }

        public String getParam() {
            return this.param;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + (this.param == null ? 0 : this.param.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Param other = (Param)obj;
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            if (this.param == null ? other.param != null : !this.param.equals(other.param)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    public static class FactoryMethod {
        public final boolean sticky;
        public final ExecutableElement method;
        public final TypeElement component;
        public final Map<Name, VariableElement> params;
        private final String setterMethod;

        private FactoryMethod(ExecutableElement method, TypeElement component) {
            this(method, component, (String)null);
        }

        private FactoryMethod(ExecutableElement method, TypeElement component, String setterMethod) {
            assert (method != null);
            assert (component != null);
            this.method = method;
            this.sticky = method.getAnnotation(Sticky.class) != null;
            this.component = component;
            this.setterMethod = setterMethod;
            this.params = FactoryMethod.map(method.getParameters());
        }

        boolean validate(Messager messager) {
            Map<Name, Element> found = FactoryMethod.map(this.component.getEnclosedElements());
            boolean success = true;
            for (Map.Entry<Name, VariableElement> param : this.params.entrySet()) {
                if (this.setterMethod == null) {
                    success &= this.validateFieldAccess(messager, found, param);
                    continue;
                }
                success &= this.validateSetterAccess(messager, found, param);
            }
            return success;
        }

        private boolean validateFieldAccess(Messager messager, Map<Name, Element> found, Map.Entry<Name, VariableElement> param) {
            if (!found.containsKey(param.getKey())) {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s has no field named %s", this.component.getSimpleName(), param.getKey()), param.getValue());
                return false;
            }
            if (!this.isParameterValid(param)) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Only primitive, enum and string types supported", param.getValue());
                return false;
            }
            return true;
        }

        private boolean isParameterValid(Map.Entry<Name, VariableElement> param) {
            VariableElement value = param.getValue();
            TypeMirror type = value.asType();
            return type.getKind().isPrimitive() || ProcessorUtil.isEnum(type) || ProcessorUtil.isString(type);
        }

        private boolean validateSetterAccess(Messager messager, Map<Name, Element> found, Map.Entry<Name, VariableElement> param) {
            if (!ProcessorUtil.hasMethod(this.component, this.setterMethod)) {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("Expected to find method '%s' in component '%s'", this.setterMethod, this.component.getSimpleName()), this.method);
                return false;
            }
            if (!ProcessorUtil.hasMethod(this.component, this.setterMethod, this.method.getParameters())) {
                StringBuilder signature = new StringBuilder();
                for (VariableElement variableElement : this.method.getParameters()) {
                    if (signature.length() > 0) {
                        signature.append(", ");
                    }
                    signature.append(variableElement.asType().toString());
                }
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("Expected to find %s.%s(%s)'", this.component.getSimpleName(), this.setterMethod, signature), this.method);
                return false;
            }
            return true;
        }

        private static <T extends Element> Map<Name, T> map(List<? extends T> elements) {
            HashMap<Name, Element> map = new HashMap<Name, Element>();
            for (Element e : elements) {
                map.put(e.getSimpleName(), e);
            }
            return map;
        }

        public String getFlagName() {
            StringBuilder sb = new StringBuilder();
            sb.append("_id_").append(FactoryModel.camelCase(this.method.getSimpleName())).append("_");
            for (VariableElement variableElement : this.method.getParameters()) {
                sb.append(variableElement.getSimpleName()).append("_");
            }
            return sb.toString();
        }

        public String getName() {
            return FactoryModel.camelCase(this.method.getSimpleName());
        }

        public String getComponentName() {
            return this.component.getSimpleName().toString();
        }

        public String getParamsFull() {
            return this.getParamsFull(this.method.getParameters());
        }

        private String getParamsFull(List<? extends VariableElement> parameters) {
            StringBuilder sb = new StringBuilder();
            for (VariableElement variableElement : this.method.getParameters()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(variableElement.asType() + " " + variableElement.getSimpleName());
            }
            return sb.toString();
        }

        public List<Param> getParams() {
            ArrayList<Param> params = new ArrayList<Param>();
            for (VariableElement variableElement : this.method.getParameters()) {
                params.add(new Param(this.component, variableElement));
            }
            return params;
        }

        public String getParamArgs() {
            StringBuilder params = new StringBuilder();
            String delim = "";
            for (VariableElement variableElement : this.method.getParameters()) {
                params.append(delim);
                params.append(new Param(this.component, variableElement).field);
                delim = ", ";
            }
            return params.toString();
        }

        public String getSetter() {
            return this.setterMethod;
        }

        public String toString() {
            String stickied = this.sticky ? "@Sticky " : "";
            String cref = "@CRef(" + this.component.getSimpleName() + ".class) ";
            String params = this.getParamsFull(this.method.getParameters());
            return "FactoryMethod [" + stickied + cref + this.method.getSimpleName() + "(" + params + ")]";
        }
    }
}

