/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.EntityManager;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.ConverterUtil;
import com.artemis.utils.IntBag;
import java.util.BitSet;

public class EntitySubscription {
    final Aspect aspect;
    private final Aspect.Builder aspectReflection;
    private final BitSet aspectCache;
    private final IntBag entities;
    private final BitSet activeEntityIds;
    private final EntityManager em;
    private final Bag<SubscriptionListener> listeners;
    private final BitSet insertedIds;
    private final BitSet removedIds;
    private final IntBag inserted;
    private final IntBag removed;
    private boolean dirty;

    EntitySubscription(World world, Aspect.Builder builder) {
        this.aspect = builder.build(world);
        this.aspectReflection = builder;
        this.aspectCache = new BitSet();
        this.em = world.getEntityManager();
        this.activeEntityIds = new BitSet();
        this.entities = new IntBag();
        this.listeners = new Bag();
        this.insertedIds = new BitSet();
        this.removedIds = new BitSet();
        this.inserted = new IntBag();
        this.removed = new IntBag();
    }

    public IntBag getEntities() {
        if (this.dirty) {
            this.rebuildCompressedActives();
            this.dirty = false;
        }
        return this.entities;
    }

    public BitSet getActiveEntityIds() {
        return this.activeEntityIds;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public Aspect.Builder getAspectBuilder() {
        return this.aspectReflection;
    }

    void processComponentIdentity(int id, BitSet componentBits) {
        this.aspectCache.set(id, this.aspect.isInterested(componentBits));
    }

    void rebuildCompressedActives() {
        BitSet bs = this.activeEntityIds;
        int size = bs.cardinality();
        this.entities.setSize(size);
        this.entities.ensureCapacity(size);
        int[] activesArray = this.entities.getData();
        int i = bs.nextSetBit(0);
        int index = 0;
        while (i >= 0) {
            activesArray[index++] = i;
            i = bs.nextSetBit(i + 1);
        }
    }

    final void check(int id) {
        boolean interested = this.aspectCache.get(this.em.getIdentity(id)) && this.em.isEnabled(id);
        boolean contains = this.activeEntityIds.get(id);
        if (interested && !contains) {
            this.insert(id);
        } else if (!interested && contains) {
            this.remove(id);
        }
    }

    private void remove(int entityId) {
        this.activeEntityIds.clear(entityId);
        this.removedIds.set(entityId);
    }

    private void insert(int entityId) {
        this.activeEntityIds.set(entityId);
        this.insertedIds.set(entityId);
    }

    void process(IntBag added, IntBag changed, IntBag deleted) {
        this.deleted(deleted);
        this.added(added);
        this.changed(changed);
        this.dirty |= this.informEntityChanges();
    }

    boolean informEntityChanges() {
        if (this.insertedIds.isEmpty() && this.removedIds.isEmpty()) {
            return false;
        }
        this.transferBitsToInts();
        int s = this.listeners.size();
        for (int i = 0; s > i; ++i) {
            if (this.removed.size() > 0) {
                this.listeners.get(i).removed(this.removed);
            }
            if (this.inserted.size() <= 0) continue;
            this.listeners.get(i).inserted(this.inserted);
        }
        this.inserted.setSize(0);
        this.removed.setSize(0);
        return true;
    }

    private void transferBitsToInts() {
        ConverterUtil.toIntBag(this.insertedIds, this.inserted);
        ConverterUtil.toIntBag(this.removedIds, this.removed);
        this.insertedIds.clear();
        this.removedIds.clear();
    }

    private final void added(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.check(ids[i]);
        }
    }

    private final void changed(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.check(ids[i]);
        }
    }

    private final void deleted(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.deleted(ids[i]);
        }
    }

    private final void deleted(int entityId) {
        if (this.activeEntityIds.get(entityId)) {
            this.remove(entityId);
        }
    }

    public void addSubscriptionListener(SubscriptionListener listener) {
        this.listeners.add(listener);
    }

    public static interface SubscriptionListener {
        public void inserted(IntBag var1);

        public void removed(IntBag var1);
    }
}

