/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Archetype;
import com.artemis.AspectSubscriptionManager;
import com.artemis.Entity;
import com.artemis.EntityEdit;
import com.artemis.EntitySubscription;
import com.artemis.EntityTransmuter;
import com.artemis.Manager;
import com.artemis.utils.Bag;
import com.artemis.utils.IntBag;
import com.artemis.utils.IntDeque;
import java.util.BitSet;

public class EntityManager
extends Manager {
    static final int NO_COMPONENTS = 1;
    private final Bag<Entity> entities;
    private final BitSet newlyCreatedEntityIds;
    private final BitSet disabled;
    private RecyclingEntityFactory recyclingEntityFactory;
    ComponentIdentityResolver identityResolver = new ComponentIdentityResolver();
    private IntBag entityToIdentity = new IntBag();
    private int highestSeenIdentity;
    private AspectSubscriptionManager subscriptionManager;

    protected EntityManager(int initialContainerSize) {
        this.entities = new Bag(initialContainerSize);
        this.disabled = new BitSet();
        this.newlyCreatedEntityIds = new BitSet();
    }

    @Override
    protected void initialize() {
        this.recyclingEntityFactory = new RecyclingEntityFactory(this);
        this.subscriptionManager = this.world.getManager(AspectSubscriptionManager.class);
    }

    protected Entity createEntityInstance() {
        Entity e = this.recyclingEntityFactory.obtain();
        this.entityToIdentity.set(e.id, 0);
        this.newlyCreatedEntityIds.set(e.id);
        return e;
    }

    protected Entity createEntityInstance(Archetype archetype) {
        Entity e = this.createEntityInstance();
        this.entityToIdentity.set(e.getId(), archetype.compositionId);
        return e;
    }

    BitSet componentBits(int entityId) {
        int identityIndex = this.entityToIdentity.get(entityId);
        if (identityIndex == 0) {
            identityIndex = this.forceResolveIdentity(entityId);
        }
        return (BitSet)this.identityResolver.composition.get(identityIndex);
    }

    @Override
    @Deprecated
    public void enabled(int entityId) {
        this.disabled.clear(entityId);
    }

    void updateCompositionIdentity(EntityEdit edit) {
        int identity = this.compositionIdentity(edit.componentBits);
        this.entityToIdentity.set(edit.entity.getId(), identity);
    }

    int compositionIdentity(BitSet componentBits) {
        int identity = this.identityResolver.getIdentity(componentBits);
        if (identity > this.highestSeenIdentity) {
            this.subscriptionManager.processComponentIdentity(identity, componentBits);
            this.highestSeenIdentity = identity;
        }
        return identity;
    }

    @Override
    @Deprecated
    public void disabled(int entityId) {
        this.disabled.set(entityId);
    }

    @Override
    public void deleted(int entityId) {
        if (this.recyclingEntityFactory.has(entityId)) {
            return;
        }
        this.newlyCreatedEntityIds.set(entityId, false);
        this.recyclingEntityFactory.free(entityId);
        this.disabled.clear(entityId);
    }

    @Override
    public void added(int entityId) {
        this.newlyCreatedEntityIds.set(entityId, false);
    }

    public boolean isActive(int entityId) {
        return this.entities.size() > entityId && !this.recyclingEntityFactory.has(entityId);
    }

    public boolean isNew(int entityId) {
        return this.newlyCreatedEntityIds.get(entityId);
    }

    @Deprecated
    public boolean isEnabled(int entityId) {
        return !this.disabled.get(entityId);
    }

    protected Entity getEntity(int entityId) {
        return this.entities.get(entityId);
    }

    @Deprecated
    public int getActiveEntityCount() {
        return 0;
    }

    @Deprecated
    public long getTotalCreated() {
        return 0L;
    }

    @Deprecated
    public long getTotalAdded() {
        return 0L;
    }

    @Deprecated
    public long getTotalDeleted() {
        return 0L;
    }

    protected int getIdentity(int entityId) {
        int identity = this.entityToIdentity.get(entityId);
        if (identity == 0) {
            identity = this.forceResolveIdentity(entityId);
        }
        return identity;
    }

    void setIdentity(Entity e, EntityTransmuter.TransmuteOperation operation) {
        this.entityToIdentity.set(e.getId(), operation.compositionId);
    }

    private int forceResolveIdentity(int entityId) {
        this.updateCompositionIdentity(this.entities.get(entityId).edit());
        return this.entityToIdentity.get(entityId);
    }

    void synchronize(EntitySubscription es) {
        int i;
        for (i = 1; this.highestSeenIdentity >= i; ++i) {
            BitSet componentBits = (BitSet)this.identityResolver.composition.get(i);
            es.processComponentIdentity(i, componentBits);
        }
        for (i = 0; i < this.entities.size(); ++i) {
            Entity e = this.entities.get(i);
            if (e == null || this.disabled.get(e.id)) continue;
            es.check(e.id);
        }
        es.informEntityChanges();
        es.rebuildCompressedActives();
    }

    private static final class RecyclingEntityFactory {
        private final EntityManager em;
        private final IntDeque limbo;
        private final BitSet recycled;
        private int nextId;

        RecyclingEntityFactory(EntityManager em) {
            this.em = em;
            this.recycled = new BitSet();
            this.limbo = new IntDeque();
        }

        void free(int entityId) {
            this.limbo.add(entityId);
            this.recycled.set(entityId);
        }

        Entity obtain() {
            if (this.limbo.isEmpty()) {
                Entity e = new Entity(this.em.world, this.nextId++);
                this.em.entities.set(e.id, e);
                return e;
            }
            int id = this.limbo.popFirst();
            this.recycled.set(id, false);
            return (Entity)this.em.entities.get(id);
        }

        boolean has(int entityId) {
            return this.recycled.get(entityId);
        }
    }

    private static final class ComponentIdentityResolver {
        private final Bag<BitSet> composition = new Bag();

        ComponentIdentityResolver() {
            this.composition.add(null);
            this.composition.add(new BitSet());
        }

        int getIdentity(BitSet components) {
            Object[] bitsets = this.composition.getData();
            int size = this.composition.size();
            for (int i = 1; size > i; ++i) {
                if (!components.equals(bitsets[i])) continue;
                return i;
            }
            this.composition.add((BitSet)components.clone());
            return size;
        }
    }
}

