/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.FactoryModel;
import com.artemis.ModelFormatter;
import com.artemis.ProcessorUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.artemis.annotations.Bind", "com.artemis.annotations.UseSetter"})
public class EntityFactoryProcessor
extends AbstractProcessor {
    private Filer filer;
    private ModelFormatter formatter;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.formatter = new ModelFormatter();
        ProcessorUtil.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> types, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || types.size() == 0) {
            return true;
        }
        HashSet<TypeElement> factoryTypes = new HashSet<TypeElement>();
        Iterator<? extends TypeElement> iterator = types.iterator();
        while (iterator.hasNext()) {
            factoryTypes.addAll(EntityFactoryProcessor.resolveTypes(roundEnv.getElementsAnnotatedWith(iterator.next())));
        }
        for (TypeElement factory : factoryTypes) {
            FactoryModel fm = new FactoryModel(factory, this.processingEnv);
            if (!fm.success) continue;
            this.generateSourceFile(fm);
        }
        return false;
    }

    private static Set<TypeElement> resolveTypes(Set<? extends Element> elements) {
        HashSet<TypeElement> factoryTypes = new HashSet<TypeElement>();
        for (Element element : elements) {
            if (element instanceof TypeElement) {
                factoryTypes.add((TypeElement)element);
                continue;
            }
            if (!(element instanceof ExecutableElement)) continue;
            factoryTypes.add((TypeElement)element.getEnclosingElement());
        }
        return factoryTypes;
    }

    private void generateSourceFile(FactoryModel model) {
        try {
            String factoryName = model.declaration.getQualifiedName() + "Impl";
            JavaFileObject src = this.filer.createSourceFile(factoryName, model.declaration);
            PrintWriter writer = new PrintWriter(src.openWriter());
            writer.println(this.formatter.generate(model));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), model.declaration);
            e.printStackTrace();
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

