/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentType;
import com.artemis.utils.Bag;
import java.util.IdentityHashMap;

public class ComponentTypeFactory {
    private final IdentityHashMap<Class<? extends Component>, ComponentType> componentTypes = new IdentityHashMap();
    private int componentTypeCount = 0;
    final Bag<ComponentType> types = new Bag();

    public ComponentType getTypeFor(Class<? extends Component> c) {
        ComponentType type = this.componentTypes.get(c);
        if (type == null) {
            int index = this.componentTypeCount++;
            type = new ComponentType(c, index);
            this.componentTypes.put(c, type);
            this.types.set(index, type);
        }
        return type;
    }

    public ComponentType getTypeFor(int index) {
        return this.types.get(index);
    }

    public int getIndexFor(Class<? extends Component> c) {
        return this.getTypeFor(c).getIndex();
    }

    protected ComponentType.Taxonomy getTaxonomy(int index) {
        return this.types.get(index).getTaxonomy();
    }

    protected boolean isPackedComponent(int index) {
        return this.types.get(index).isPackedComponent();
    }
}

