/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.ComponentType;
import com.artemis.PooledComponent;
import com.artemis.utils.Bag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.ReflectionException;

class ComponentPool {
    private Bag<Pool> pools = new Bag();

    ComponentPool() {
    }

    <T extends PooledComponent> T obtain(Class<T> componentClass, ComponentType type) throws ReflectionException {
        Pool pool = this.getPool(type.getIndex());
        return (T)(pool.size() > 0 ? pool.obtain() : (PooledComponent)ClassReflection.newInstance(componentClass));
    }

    void free(PooledComponent c, ComponentType type) {
        this.free(c, type.getIndex());
    }

    void free(PooledComponent c, int typeIndex) {
        c.reset();
        this.getPool(typeIndex).free(c);
    }

    private <T extends PooledComponent> Pool getPool(int typeIndex) {
        Pool pool = this.pools.safeGet(typeIndex);
        if (pool == null) {
            pool = new Pool();
            this.pools.set(typeIndex, pool);
        }
        return pool;
    }

    private static class Pool {
        private final Bag<PooledComponent> cache = new Bag();

        private Pool() {
        }

        <T extends PooledComponent> T obtain() {
            return (T)this.cache.removeLast();
        }

        int size() {
            return this.cache.size();
        }

        void free(PooledComponent component) {
            this.cache.add(component);
        }
    }
}

